/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Set;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.el.context.AbstractMapContext;

public class OutboundAttachmentMapContext
extends AbstractMapContext<String, DataHandler> {
    private MuleMessage message;

    public OutboundAttachmentMapContext(MuleMessage message) {
        this.message = message;
    }

    @Override
    public void clear() {
        for (String name : this.message.getOutboundAttachmentNames()) {
            try {
                this.message.removeOutboundAttachment(name);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.message.getOutboundAttachmentNames().contains(key);
    }

    @Override
    public DataHandler get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.message.getOutboundAttachment((String)key);
    }

    @Override
    public Set<String> keySet() {
        return this.message.getOutboundPropertyNames();
    }

    @Override
    public DataHandler put(String key, DataHandler value) {
        DataHandler previousValue = this.get(key);
        try {
            this.message.addOutboundAttachment(key, value);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
        return previousValue;
    }

    @Override
    public DataHandler remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        DataHandler previousValue = this.get(key);
        try {
            this.message.removeOutboundAttachment((String)key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return previousValue;
    }
}

