/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression.transformers;

import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.AbstractExpressionTransformer;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.transport.NullPayload;

public class ExpressionTransformer
extends AbstractExpressionTransformer {
    private boolean returnSourceIfNull = false;

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object[] results = new Object[this.arguments.size()];
        int i = 0;
        for (ExpressionArgument argument : this.arguments) {
            try {
                results[i] = argument.evaluate(message);
            }
            catch (RequiredValueException e) {
                if (!argument.isOptional()) {
                    throw e;
                }
                this.logger.warn((Object)e.getMessage());
            }
            catch (ExpressionRuntimeException e) {
                throw new TransformerException(this, (Throwable)e);
            }
            if (!argument.isOptional() && results[i] == null) {
                throw new TransformerException(CoreMessages.expressionEvaluatorReturnedNull(argument.getExpressionConfig().getEvaluator(), argument.getExpressionConfig().getExpression()), this);
            }
            ++i;
        }
        if (this.isReturnSourceIfNull() && this.checkIfAllAreNull(results)) {
            return message;
        }
        if (results.length == 1) {
            return results[0];
        }
        return results;
    }

    private boolean checkIfAllAreNull(Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null || objects[i] instanceof NullPayload) continue;
            return false;
        }
        return true;
    }

    public boolean isReturnSourceIfNull() {
        return this.returnSourceIfNull;
    }

    public void setReturnSourceIfNull(boolean returnSourceIfNull) {
        this.returnSourceIfNull = returnSourceIfNull;
    }
}

