/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle.processor;

import org.mule.api.MuleEvent;
import org.mule.api.NameableObject;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractFilteringMessageProcessor;

public class ProcessIfStartedMessageProcessor
extends AbstractFilteringMessageProcessor {
    protected Startable startable;
    protected LifecycleState lifecycleState;

    public ProcessIfStartedMessageProcessor(Startable startable, LifecycleState lifecycleState) {
        this.startable = startable;
        this.lifecycleState = lifecycleState;
    }

    @Override
    protected boolean accept(MuleEvent event) {
        return this.lifecycleState.isStarted();
    }

    @Override
    protected MuleEvent handleUnaccepted(MuleEvent event) throws LifecycleException {
        throw new LifecycleException(CoreMessages.isStopped(this.getStartableName(this.startable)), (Object)event.getMessage());
    }

    protected String getStartableName(Startable startableObject) {
        if (startableObject instanceof NameableObject) {
            return ((NameableObject)((Object)startableObject)).getName();
        }
        return startableObject.toString();
    }
}

