/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Map;
import javax.activation.DataHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.el.context.AbstractELTestCase;

public class MessageAttachmentsTestCase
extends AbstractELTestCase {
    public MessageAttachmentsTestCase(AbstractELTestCase.Variant variant) {
        super(variant);
    }

    @Test
    public void inboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Assert.assertTrue((boolean)(this.evaluate("message.inboundAttachments", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToInboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.inboundAttachments='foo'", (MuleMessage)message);
    }

    @Test
    public void inboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", dataHandler);
        Assert.assertEquals((Object)dataHandler, (Object)this.evaluate("message.inboundAttachments['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToInboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", dataHandler);
        this.assertUnsupportedOperation("message.inboundAttachments['foo']=new DataHandler('bar','text/plain')", (MuleMessage)message);
    }

    @Test
    public void assignValueToNewInboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertUnsupportedOperation("message.inboundAttachments['foo_new']=new DataHandler('bar','text/plain')", (MuleMessage)message);
    }

    @Test
    public void outboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Assert.assertTrue((boolean)(this.evaluate("message.outboundAttachments", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToOutboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.outboundAttachments='foo'", (MuleMessage)message);
    }

    @Test
    public void outboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        message.addOutboundAttachment("foo", dataHandler);
        Assert.assertEquals((Object)dataHandler, (Object)this.evaluate("message.outboundAttachments['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToOutboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        this.evaluate("message.outboundAttachments['foo']=new DataHandler('bar','text/plain')", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundAttachment("foo").getContent());
    }

    @Test
    public void assignValueToNewOutboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.outboundAttachments['foo']=new DataHandler('bar','text/plain')", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundAttachment("foo").getContent());
    }
}

