/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.config.MuleConfiguration;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class RegExFilterTestCase
extends AbstractMuleTestCase {
    private static final String PATTERN = "(.*) brown fox";

    @Test
    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        Assert.assertNull((Object)filter.getPattern());
        Assert.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern(PATTERN);
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        Assert.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    @Test
    public void testRegexFilter() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quick "));
        Assert.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        Assert.assertFalse((boolean)filter.accept((Object)"he quick brown fox"));
        filter.setPattern(PATTERN);
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)" brown fox"));
        Assert.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        Assert.assertFalse((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*) brown (.*)");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)PATTERN));
        Assert.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*)");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
    }

    @Test
    public void testNullInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        Assert.assertFalse((boolean)filter.accept((Object)null));
    }

    @Test
    public void testMuleMessageInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.isCacheMessageAsBytes()).thenReturn((Object)false);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"The quick brown fox", muleContext);
        Assert.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    @Test
    public void testByteArrayInput() {
        System.setProperty("mule.encoding", "UTF-8");
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        byte[] bytes = "The quick brown fox".getBytes();
        Assert.assertTrue((boolean)filter.accept((Object)bytes));
    }

    @Test
    public void testCharArrayInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        Assert.assertNotNull((Object)filter.getPattern());
        char[] chars = "The quick brown fox".toCharArray();
        Assert.assertTrue((boolean)filter.accept((Object)chars));
    }

    @Test
    public void testEqualsWithSamePattern() {
        RegExFilter filter1 = new RegExFilter(PATTERN);
        RegExFilter filter2 = new RegExFilter(PATTERN);
        Assert.assertEquals((Object)filter1, (Object)filter2);
    }

    @Test
    public void testEqualsWithDifferentPattern() {
        RegExFilter filter1 = new RegExFilter("foo");
        RegExFilter filter2 = new RegExFilter("bar");
        Assert.assertFalse((boolean)filter1.equals((Object)filter2));
    }

    @Test
    public void testEqualsWithEqualPatternAndDifferentFlags() {
        RegExFilter filter1 = new RegExFilter(PATTERN, 32);
        RegExFilter filter2 = new RegExFilter(PATTERN, 2);
        Assert.assertFalse((boolean)filter1.equals((Object)filter2));
        filter1 = new RegExFilter(PATTERN, 32);
        filter2 = new RegExFilter(PATTERN, 32);
        Assert.assertEquals((Object)filter1, (Object)filter2);
    }
}

