/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.CompositeConverter;

@SmallTest
public class CompositeConverterTestCase {
    private MockConverter mockConverterA = (MockConverter)Mockito.mock(MockConverter.class);
    private MockConverter mockConverterB = (MockConverter)Mockito.mock(MockConverter.class);

    @Test(expected=IllegalArgumentException.class)
    public void rejectsEmptyCompositeTransformer() throws Exception {
        new CompositeConverter(new Transformer[0]);
    }

    @Test
    public void isSourceTypeSupported() {
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        Mockito.when((Object)mockTransformer.isSourceTypeSupported(String.class)).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        Assert.assertTrue((boolean)chain.isSourceTypeSupported(String.class));
    }

    @Test
    public void isSourceDataTypeSupported() {
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        Mockito.when((Object)mockTransformer.isSourceDataTypeSupported(DataType.STRING_DATA_TYPE)).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        Assert.assertTrue((boolean)chain.isSourceDataTypeSupported(DataType.STRING_DATA_TYPE));
    }

    @Test
    public void getSourceTypes() {
        Class[] dataTypes = new Class[]{String.class};
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        Mockito.when((Object)mockTransformer.getSourceTypes()).thenReturn(Arrays.asList(dataTypes));
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        Assert.assertEquals(String.class, chain.getSourceTypes().get(0));
    }

    @Test
    public void getSourceDataTypes() {
        DataType[] dataTypes = new DataType[]{DataType.STRING_DATA_TYPE};
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        Mockito.when((Object)mockTransformer.getSourceDataTypes()).thenReturn(Arrays.asList(dataTypes));
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        Assert.assertEquals((Object)DataType.STRING_DATA_TYPE, chain.getSourceDataTypes().get(0));
    }

    @Test
    public void isAcceptNull() {
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        Mockito.when((Object)mockTransformer.isAcceptNull()).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        Assert.assertTrue((boolean)chain.isAcceptNull());
    }

    @Test
    public void isIgnoreBadInput() {
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        Mockito.when((Object)mockTransformer.isIgnoreBadInput()).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        Assert.assertTrue((boolean)chain.isIgnoreBadInput());
    }

    @Test
    public void setReturnClass() {
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        chain.setReturnClass(String.class);
        ((Transformer)Mockito.verify((Object)mockTransformer, (VerificationMode)Mockito.atLeastOnce())).setReturnClass(String.class);
    }

    @Test
    public void setReturnDataType() {
        Transformer mockTransformer = (Transformer)Mockito.mock(MockConverter.class);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{mockTransformer});
        chain.setReturnDataType(DataType.STRING_DATA_TYPE);
        ((Transformer)Mockito.verify((Object)mockTransformer, (VerificationMode)Mockito.atLeastOnce())).setReturnDataType(DataType.STRING_DATA_TYPE);
    }

    @Test
    public void getReturnClass() {
        ((MockConverter)Mockito.doReturn(String.class).when((Object)this.mockConverterB)).getReturnClass();
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals(String.class, (Object)chain.getReturnClass());
    }

    @Test
    public void getReturnDataType() {
        ((MockConverter)Mockito.doReturn((Object)DataType.STRING_DATA_TYPE).when((Object)this.mockConverterB)).getReturnDataType();
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((Object)DataType.STRING_DATA_TYPE, (Object)chain.getReturnDataType());
    }

    @Test
    public void getMimeType() {
        ((MockConverter)Mockito.doReturn((Object)"application/xml").when((Object)this.mockConverterB)).getMimeType();
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((String)"application/xml", (String)chain.getMimeType());
    }

    @Test
    public void getEncoding() {
        ((MockConverter)Mockito.doReturn((Object)"UTF-8").when((Object)this.mockConverterB)).getEncoding();
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((String)"UTF-8", (String)chain.getEncoding());
    }

    @Test
    public void getEndpoint() {
        ImmutableEndpoint mockImmutableEndpoint = (ImmutableEndpoint)Mockito.mock(ImmutableEndpoint.class);
        ((MockConverter)Mockito.doReturn((Object)mockImmutableEndpoint).when((Object)this.mockConverterA)).getEndpoint();
        ((MockConverter)Mockito.doReturn((Object)mockImmutableEndpoint).when((Object)this.mockConverterB)).getEndpoint();
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((Object)mockImmutableEndpoint, (Object)chain.getEndpoint());
    }

    @Test
    public void setEndpoint() {
        ImmutableEndpoint mockImmutableEndpoint = (ImmutableEndpoint)Mockito.mock(ImmutableEndpoint.class);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        chain.setEndpoint(mockImmutableEndpoint);
        ((MockConverter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).setEndpoint(mockImmutableEndpoint);
        ((MockConverter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).setEndpoint(mockImmutableEndpoint);
    }

    @Test
    public void priorityWeighting() throws Exception {
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Mockito.when((Object)this.mockConverterA.getPriorityWeighting()).thenReturn((Object)1);
        Mockito.when((Object)this.mockConverterB.getPriorityWeighting()).thenReturn((Object)2);
        int priorityWeighting = chain.getPriorityWeighting();
        Assert.assertEquals((int)3, (int)priorityWeighting);
    }

    @Test
    public void initialise() throws Exception {
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        chain.initialise();
        ((MockConverter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).initialise();
        ((MockConverter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).initialise();
    }

    @Test
    public void dispose() throws Exception {
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        chain.dispose();
        ((MockConverter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).dispose();
        ((MockConverter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).dispose();
    }

    @Test
    public void setMuleContext() {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        chain.setMuleContext(mockMuleContext);
        ((MockConverter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).setMuleContext(mockMuleContext);
        ((MockConverter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).setMuleContext(mockMuleContext);
    }

    @Test
    public void transform() throws Exception {
        ((MockConverter)Mockito.doReturn((Object)"MyOutput1").when((Object)this.mockConverterA)).transform(Matchers.any());
        ((MockConverter)Mockito.doReturn((Object)"UTF-8").when((Object)this.mockConverterA)).getEncoding();
        ((MockConverter)Mockito.doReturn((Object)"MyOutput2").when((Object)this.mockConverterB)).transform(Matchers.eq((Object)"MyOutput1"), (String)Matchers.eq((Object)"UTF-8"));
        ((MockConverter)Mockito.doReturn((Object)"UTF-8").when((Object)this.mockConverterB)).getEncoding();
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        Object output = chain.transform((Object)"MyInput");
        ((MockConverter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.times((int)1))).transform("MyInput");
        ((MockConverter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.times((int)1))).transform("MyOutput1", "UTF-8");
        Assert.assertEquals((Object)"MyOutput2", (Object)output);
    }

    @Test
    public void appliesTransformerChainOnMessage() throws Exception {
        CompositeConverter chain = new CompositeConverter(new Transformer[]{this.mockConverterA, this.mockConverterB});
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        ((MuleEvent)Mockito.doReturn((Object)message).when((Object)event)).getMessage();
        chain.process(event);
        ((MuleMessage)Mockito.verify((Object)message, (VerificationMode)Mockito.times((int)1))).applyTransformers(event, new Transformer[]{chain});
    }

    private static interface MockConverter
    extends Transformer,
    Converter {
    }
}

