/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.InputStream;
import java.util.Arrays;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpInputStream;
import org.mule.transport.sftp.SftpReceiverRequesterUtil;
import org.mule.transport.sftp.notification.SftpNotifier;

public class SftpMessageReceiver
extends AbstractPollingMessageReceiver {
    private SftpReceiverRequesterUtil sftpRRUtil = null;

    public SftpMessageReceiver(SftpConnector connector, FlowConstruct flow, InboundEndpoint endpoint, long frequency) throws CreateException {
        super((Connector)connector, flow, endpoint);
        this.setFrequency(frequency);
        this.sftpRRUtil = new SftpReceiverRequesterUtil((ImmutableEndpoint)endpoint);
    }

    public void poll() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pooling. Called at endpoint " + this.endpoint.getEndpointURI()));
        }
        try {
            Object[] files = this.sftpRRUtil.getAvailableFiles(false);
            if (files.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Pooling. No matching files found at endpoint " + this.endpoint.getEndpointURI()));
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Pooling. " + files.length + " files found at " + this.endpoint.getEndpointURI() + ":" + Arrays.toString(files)));
                }
                for (String string : files) {
                    if (this.getLifecycleState().isStopping()) break;
                    this.routeFile(string);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Pooling. Routed all " + files.length + " files found at " + this.endpoint.getEndpointURI()));
                }
            }
        }
        catch (MessagingException e) {
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in poll", (Throwable)e);
            this.connector.getMuleContext().getExceptionListener().handleException(e);
            throw e;
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    protected void routeFile(final String path) throws Exception {
        ExecutionTemplate executionTemplate = this.createExecutionTemplate();
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                SftpNotifier notifier = new SftpNotifier((SftpConnector)SftpMessageReceiver.this.connector, SftpMessageReceiver.this.createNullMuleMessage(), SftpMessageReceiver.this.endpoint, SftpMessageReceiver.this.flowConstruct.getName());
                InputStream inputStream = SftpMessageReceiver.this.sftpRRUtil.retrieveFile(path, notifier);
                if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                    SftpMessageReceiver.this.logger.debug((Object)("Routing file: " + path));
                }
                MuleMessage message = SftpMessageReceiver.this.createMuleMessage(inputStream);
                message.setOutboundProperty("filename", (Object)path);
                message.setOutboundProperty("originalFilename", (Object)path);
                notifier.setMessage(message);
                SftpMessageReceiver.this.routeMessage(message);
                if (SftpMessageReceiver.this.logger.isDebugEnabled()) {
                    SftpMessageReceiver.this.logger.debug((Object)("Routed file: " + path));
                }
                return null;
            }
        });
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        this.logger.debug((Object)"the filter said no, now trying to close the payload stream");
        try {
            SftpInputStream payload = (SftpInputStream)message.getPayload();
            payload.close();
        }
        catch (Exception e) {
            this.logger.debug((Object)"unable to close payload stream", (Throwable)e);
        }
        return super.handleUnacceptedFilter(message);
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }
}

