/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon;

import de.odysseus.staxon.Pair;
import de.odysseus.staxon.XMLStreamReaderScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractXMLStreamReader<T>
implements XMLStreamReader {
    private static final Location UNKNOWN_LOCATION = new Location(){

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    };
    private final Queue<Event> queue = new LinkedList<Event>();
    private XMLStreamReaderScope<T> scope;
    private boolean moreTokens;
    private Event event;
    private List<Pair<String, String>> pendingAttributes = new ArrayList<Pair<String, String>>(16);
    private String encodingScheme;
    private String version;
    private Boolean standalone;

    static String getEventName(int type) {
        switch (type) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return String.valueOf(type);
    }

    static boolean hasText(int type) {
        return type == 4 || type == 5 || type == 12 || type == 11 || type == 9 || type == 6;
    }

    public AbstractXMLStreamReader(T rootInfo) {
        this.scope = new XMLStreamReaderScope<T>("", rootInfo);
    }

    private void ensureStartTagClosed() throws XMLStreamException {
        if (!this.scope.isStartTagClosed()) {
            if (!this.pendingAttributes.isEmpty()) {
                for (Pair<String, String> attribute : this.pendingAttributes) {
                    int colon;
                    String name = attribute.getFirst();
                    String prefix = name.substring(0, colon = name.indexOf(58));
                    String namespaceURI = this.scope.getNamespaceURI(prefix);
                    if (namespaceURI == null || "".equals(namespaceURI)) {
                        throw new XMLStreamException("Unbound attribute prefix: " + prefix);
                    }
                    QName qName = new QName(namespaceURI, name.substring(colon + 1), prefix);
                    this.scope.addAttribute(qName, attribute.getSecond());
                }
                this.pendingAttributes.clear();
            }
            this.scope.setStartTagClosed(true);
        }
    }

    protected void readStartDocument(String version, String encodingScheme, Boolean standalone) {
        this.queue.add(new Event(7, this.scope, null));
        this.version = version;
        this.encodingScheme = encodingScheme;
        this.standalone = standalone;
    }

    protected XMLStreamReaderScope<T> readStartElementTag(String name) throws XMLStreamException {
        this.ensureStartTagClosed();
        int colon = name.indexOf(58);
        this.scope = colon < 0 ? new XMLStreamReaderScope<T>(this.scope, "", name) : new XMLStreamReaderScope<T>(this.scope, name.substring(0, colon), name.substring(colon + 1));
        this.queue.add(new Event(1, this.scope, null));
        return this.scope;
    }

    protected void readAttr(String name, String value) throws XMLStreamException {
        if ("xmlns".equals(name)) {
            this.scope.addNamespaceURI("", value);
        } else if (name.startsWith("xmlns") && name.charAt("xmlns".length()) == ':') {
            this.scope.addNamespaceURI(name.substring("xmlns".length() + 1), value);
        } else {
            int colon = name.indexOf(58);
            if (colon < 0) {
                this.scope.addAttribute(new QName(name), value);
            } else {
                String prefix = name.substring(0, colon);
                String namespaceURI = this.scope.getNamespaceURI(prefix);
                if (namespaceURI == null || "".equals(namespaceURI)) {
                    this.pendingAttributes.add(new Pair<String, String>(name, value));
                } else {
                    QName qName = new QName(namespaceURI, name.substring(colon + 1), prefix);
                    this.scope.addAttribute(qName, value);
                }
            }
        }
    }

    protected void readText(String text, int type) throws XMLStreamException {
        if (!AbstractXMLStreamReader.hasText(type)) {
            throw new XMLStreamException("Unexpected event type " + this.getEventName(), this.getLocation());
        }
        this.ensureStartTagClosed();
        this.queue.add(new Event(type, this.scope, text));
    }

    protected void readPI(String target, String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        String text = data == null ? target : target + ':' + data;
        this.queue.add(new Event(3, this.scope, text));
    }

    protected void readEndElementTag() throws XMLStreamException {
        this.ensureStartTagClosed();
        this.queue.add(new Event(2, this.scope, null));
        this.scope = this.scope.getParent();
    }

    protected void readEndDocument() {
        this.queue.add(new Event(8, this.scope, null));
    }

    protected void init() throws XMLStreamException {
        try {
            this.moreTokens = this.consume(this.scope);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        this.event = this.hasNext() ? this.queue.remove() : new Event(8, this.scope, null);
    }

    protected abstract boolean consume(XMLStreamReaderScope<T> var1) throws XMLStreamException, IOException;

    @Override
    public void require(int eventType, String namespaceURI, String localName) throws XMLStreamException {
        if (eventType != this.getEventType()) {
            throw new XMLStreamException("expected event type " + AbstractXMLStreamReader.getEventName(eventType) + ", was " + AbstractXMLStreamReader.getEventName(this.getEventType()));
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("expected namespace " + namespaceURI + ", was " + this.getNamespaceURI());
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException("expected local name " + localName + ", was " + this.getLocalName());
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        this.require(1, null, null);
        StringBuilder builder = null;
        String leadText = null;
        block5: while (true) {
            switch (this.next()) {
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    if (leadText == null) {
                        leadText = this.getText();
                        continue block5;
                    }
                    if (builder == null) {
                        builder = new StringBuilder(leadText);
                    }
                    builder.append(this.getText());
                    continue block5;
                }
                case 3: 
                case 5: {
                    continue block5;
                }
                case 2: {
                    return builder == null ? leadText : builder.toString();
                }
            }
            break;
        }
        throw new XMLStreamException("Unexpected event type " + this.getEventName(), this.getLocation());
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        try {
            while (this.queue.isEmpty() && this.moreTokens) {
                this.moreTokens = this.consume(this.scope);
            }
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        return !this.queue.isEmpty();
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more events");
        }
        this.event = this.queue.remove();
        return this.event.getType();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (!this.isStartElement() && !this.isEndElement()) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    @Override
    public void close() throws XMLStreamException {
        this.scope = null;
        this.queue.clear();
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.getEventType() == 4 || this.getEventType() == 12) {
            for (char ch : this.getText().toCharArray()) {
                if (Character.isWhitespace(ch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getAttributeCount() {
        return this.event.getScope().getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.event.getScope().getAttributeName(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.getAttributeName(index).getLocalPart();
    }

    @Override
    public String getAttributeValue(int index) {
        return this.event.getScope().getAttributeValue(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.getAttributeName(index).getPrefix();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.getAttributeName(index).getNamespaceURI();
    }

    @Override
    public String getAttributeType(int index) {
        return null;
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return index < this.getAttributeCount();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.event.getScope().getAttributeValue(namespaceURI, localName);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.event.getScope().getNamespaceURI(prefix);
    }

    @Override
    public int getNamespaceCount() {
        return this.hasName() ? Integer.valueOf(this.event.getScope().getNamespaceCount()) : null;
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.hasName() ? this.event.getScope().getNamespacePrefix(index) : null;
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.hasName() ? this.event.getScope().getNamespaceURI(index) : null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.event.getScope();
    }

    @Override
    public int getEventType() {
        return this.event.getType();
    }

    protected String getEventName() {
        return AbstractXMLStreamReader.getEventName(this.getEventType());
    }

    @Override
    public Location getLocation() {
        return UNKNOWN_LOCATION;
    }

    @Override
    public boolean hasText() {
        return AbstractXMLStreamReader.hasText(this.getEventType());
    }

    @Override
    public String getText() {
        return this.hasText() ? this.event.getText() : null;
    }

    @Override
    public char[] getTextCharacters() {
        return this.hasText() ? this.event.getText().toCharArray() : null;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        int count = Math.min(length, this.getTextLength());
        if (count > 0) {
            System.arraycopy(this.getTextCharacters(), sourceStart, target, targetStart, count);
        }
        return count;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.hasText() ? this.event.getText().length() : 0;
    }

    @Override
    public boolean hasName() {
        return this.getEventType() == 1 || this.getEventType() == 2;
    }

    @Override
    public QName getName() {
        return this.hasName() ? new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix()) : null;
    }

    @Override
    public String getLocalName() {
        return this.hasName() ? this.event.getScope().getLocalName() : null;
    }

    @Override
    public String getNamespaceURI() {
        return this.hasName() ? this.event.getScope().getNamespaceURI(this.event.getScope().getPrefix()) : null;
    }

    @Override
    public String getPrefix() {
        return this.hasName() ? this.event.getScope().getPrefix() : null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return this.standaloneSet() ? this.standalone : false;
    }

    @Override
    public boolean standaloneSet() {
        return this.standalone != null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.encodingScheme;
    }

    @Override
    public String getPITarget() {
        if (this.event.getType() != 3) {
            return null;
        }
        int colon = this.event.getText().indexOf(58);
        return colon < 0 ? this.event.getText() : this.event.getText().substring(0, colon);
    }

    @Override
    public String getPIData() {
        if (this.event.getType() != 3) {
            return null;
        }
        int colon = this.event.getText().indexOf(58);
        return colon < 0 ? null : this.event.getText().substring(colon + 1);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getEventName() + ")";
    }

    class Event {
        private final int type;
        private final XMLStreamReaderScope<T> scope;
        private final String text;

        Event(int type, XMLStreamReaderScope<T> scope, String text) {
            this.type = type;
            this.scope = scope;
            this.text = text;
        }

        XMLStreamReaderScope<T> getScope() {
            return this.scope;
        }

        int getType() {
            return this.type;
        }

        String getText() {
            return this.text;
        }

        public String toString() {
            return AbstractXMLStreamReader.getEventName(this.type) + ": " + (this.getText() != null ? this.getText() : AbstractXMLStreamReader.this.getLocalName());
        }
    }
}

