/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.AbstractXMLStreamWriter;
import de.odysseus.staxon.XMLStreamWriterScope;
import de.odysseus.staxon.json.JsonXMLStreamScopeInfo;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class JsonXMLStreamWriter
extends AbstractXMLStreamWriter<ScopeInfo> {
    private final JsonStreamTarget target;
    private final boolean multiplePI;
    private final boolean autoEndArray;
    private final boolean skipSpace;

    static boolean isWhitespace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public JsonXMLStreamWriter(JsonStreamTarget target, boolean multiplePI) {
        super(new ScopeInfo());
        this.target = target;
        this.multiplePI = multiplePI;
        this.autoEndArray = true;
        this.skipSpace = true;
    }

    private String getFieldName(String prefix, String localName) {
        return "".equals(prefix) ? localName : prefix + ':' + localName;
    }

    @Override
    protected void writeStartElementTag(XMLStreamWriterScope<ScopeInfo> newScope) throws XMLStreamException {
        ScopeInfo parentInfo = (ScopeInfo)this.getScope().getInfo();
        if (parentInfo.hasText()) {
            if (!this.skipSpace || !JsonXMLStreamWriter.isWhitespace(parentInfo.getText())) {
                throw new XMLStreamException("Mixed content is not supported: '" + parentInfo.getText() + "'");
            }
            parentInfo.setText(null);
        }
        String fieldName = this.getFieldName(newScope.getPrefix(), newScope.getLocalName());
        if (parentInfo.pendingStartArray) {
            this.writeStartArray(fieldName);
        }
        try {
            if (parentInfo.getArrayName() == null) {
                if (!parentInfo.startObjectWritten) {
                    this.target.startObject();
                    parentInfo.startObjectWritten = true;
                }
            } else if (this.autoEndArray && !fieldName.equals(parentInfo.getArrayName())) {
                this.writeEndArray();
            }
            if (parentInfo.getArrayName() == null) {
                this.target.name(fieldName);
            } else {
                parentInfo.incArraySize();
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot write start element: " + fieldName, e);
        }
        newScope.setInfo(new ScopeInfo());
    }

    @Override
    protected void writeStartElementTagEnd() throws XMLStreamException {
        if (this.getScope().isEmptyElement()) {
            this.writeEndElementTag();
        }
    }

    @Override
    protected void writeEndElementTag() throws XMLStreamException {
        try {
            if (((ScopeInfo)this.getScope().getInfo()).hasText()) {
                if (((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                    this.target.name("$");
                }
                this.target.value(((ScopeInfo)this.getScope().getInfo()).getText());
            }
            if (this.autoEndArray && ((ScopeInfo)this.getScope().getInfo()).getArrayName() != null) {
                this.writeEndArray();
            }
            if (((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                this.target.endObject();
            } else if (!((ScopeInfo)this.getScope().getInfo()).hasText()) {
                this.target.value(null);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot write end element: " + this.getFieldName(this.getScope().getPrefix(), this.getScope().getLocalName()), e);
        }
    }

    @Override
    protected void writeAttr(String name, String value) throws XMLStreamException {
        try {
            if (!((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                this.target.startObject();
                ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
            }
            this.target.name('@' + name);
            this.target.value(value);
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot write attribute: " + name, e);
        }
    }

    @Override
    protected void writeText(String data, int type) throws XMLStreamException {
        switch (type) {
            case 4: 
            case 12: {
                if (this.getScope().getLastChild() != null) {
                    if (this.skipSpace && JsonXMLStreamWriter.isWhitespace(data)) break;
                    throw new XMLStreamException("Mixed content is not supported: '" + ((ScopeInfo)this.getScope().getInfo()).getText() + "'");
                }
                ((ScopeInfo)this.getScope().getInfo()).addText(data);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot write data of type " + type);
            }
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        super.writeStartDocument(encoding, version);
        try {
            this.target.startObject();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot start document", e);
        }
        ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        super.writeEndDocument();
        try {
            this.target.endObject();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot end document", e);
        }
        ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = false;
    }

    public void writeStartArray(String fieldName) throws XMLStreamException {
        if (this.autoEndArray && ((ScopeInfo)this.getScope().getInfo()).getArrayName() != null) {
            this.writeEndArray();
        }
        ((ScopeInfo)this.getScope().getInfo()).startArray(fieldName);
        ((ScopeInfo)this.getScope().getInfo()).pendingStartArray = false;
        try {
            if (!((ScopeInfo)this.getScope().getInfo()).startObjectWritten) {
                this.target.startObject();
                ((ScopeInfo)this.getScope().getInfo()).startObjectWritten = true;
            }
            this.target.name(fieldName);
            this.target.startArray();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot start array: " + fieldName, e);
        }
    }

    public void writeEndArray() throws XMLStreamException {
        ((ScopeInfo)this.getScope().getInfo()).endArray();
        try {
            this.target.endArray();
        }
        catch (IOException e) {
            throw new XMLStreamException("Cannot end array: " + ((ScopeInfo)this.getScope().getInfo()).getArrayName(), e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        super.close();
        try {
            this.target.close();
        }
        catch (IOException e) {
            throw new XMLStreamException("Close failed", e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.target.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException("Flush failed", e);
        }
    }

    @Override
    protected void writePI(String target, String data) throws XMLStreamException {
        if (this.multiplePI && "xml-multiple".equals(target)) {
            if (data == null || data.trim().isEmpty()) {
                ((ScopeInfo)this.getScope().getInfo()).pendingStartArray = true;
            } else {
                this.writeStartArray(data.trim());
            }
        }
    }

    static class ScopeInfo
    extends JsonXMLStreamScopeInfo {
        private String leadText = null;
        private StringBuilder builder = null;
        boolean startObjectWritten = false;
        boolean pendingStartArray = false;

        ScopeInfo() {
        }

        void addText(String data) {
            if (this.leadText == null) {
                this.leadText = data;
            } else {
                if (this.builder == null) {
                    this.builder = new StringBuilder(this.leadText);
                }
                this.builder.append(data);
            }
        }

        boolean hasText() {
            return this.leadText != null;
        }

        String getText() {
            return this.builder == null ? this.leadText : this.builder.toString();
        }

        void setText(String data) {
            this.leadText = data;
            this.builder = null;
        }
    }
}

