/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.types;

public class ShortBitSet {
    private static final char[] s_bitMasks = new char[]{'\u0001', '\u0002', '\u0004', '\b', '\u0010', ' ', '@', '\u0080', '\u0100', '\u0200', '\u0400', '\u0800', '\u1000', '\u2000', '\u4000', '\u8000'};
    private char m_bits;

    public boolean isSet(int value) {
        return (this.m_bits & s_bitMasks[value]) != 0;
    }

    public void add(int value) {
        this.m_bits = (char)(this.m_bits | s_bitMasks[value]);
    }

    public void remove(int value) {
        this.m_bits = (char)(this.m_bits & ~s_bitMasks[value]);
    }

    public void clear() {
        this.m_bits = '\u0000';
    }

    public void setRange(int min, int max) {
        int mask = (s_bitMasks[max] << 1) - s_bitMasks[min];
        this.m_bits = (char)(this.m_bits | mask);
    }
}

