/*
 * $Id: Converter.java 24089 2012-03-15 20:55:29Z pablo.kraan $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.transformer;

/**
 * Marker for {@link Transformer} that are data type converters, ie: convert
 * data from a type to another without modifying the meaning of the data.
 */
public interface Converter
{

    int MAX_PRIORITY_WEIGHTING = 10;
    int MIN_PRIORITY_WEIGHTING = 1;
    int DEFAULT_PRIORITY_WEIGHTING = MIN_PRIORITY_WEIGHTING;

    /**
     * If two or more discoverable transformers are equal, this value can be
     * used to select the correct one
     *
     * @return the priority weighting for this transformer. This is a value between
     *         {@link #MIN_PRIORITY_WEIGHTING} and {@link #MAX_PRIORITY_WEIGHTING}.
     */
    int getPriorityWeighting();

    /**
     * If 2 or more discoverable transformers are equal, this value can be used
     * to select the correct one
     *
     * @param weighting the priority weighting for this transformer. This is a value between
     *                  {@link #MIN_PRIORITY_WEIGHTING} and {@link #MAX_PRIORITY_WEIGHTING}.
     */
    void setPriorityWeighting(int weighting);

}
