/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.resource.spi.work.Work;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.retry.RetryContext;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ftp.FtpConnector;
import org.mule.transport.ftp.FtpMuleMessageFactory;

public class FtpMessageReceiver
extends AbstractPollingMessageReceiver {
    private static final int FTP_LIST_PAGE_SIZE = 25;
    protected final FtpConnector connector;
    protected final FilenameFilter filenameFilter;
    protected final Set<String> scheduledFiles = Collections.synchronizedSet(new HashSet());
    protected final Set<String> currentFiles = Collections.synchronizedSet(new HashSet());

    public FtpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, long frequency) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setFrequency(frequency);
        this.connector = (FtpConnector)connector;
        this.filenameFilter = endpoint.getFilter() instanceof FilenameFilter ? (FilenameFilter)endpoint.getFilter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        FTPFile[] files = this.listFiles();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Poll encountered " + files.length + " new file(s)"));
        }
        Set<String> set = this.scheduledFiles;
        synchronized (set) {
            for (FTPFile file : files) {
                if (this.getLifecycleState().isStopping()) break;
                String fileName = file.getName();
                if (this.scheduledFiles.contains(fileName) || this.currentFiles.contains(fileName)) continue;
                this.scheduledFiles.add(fileName);
                this.getWorkManager().scheduleWork((Work)new FtpWork(fileName, file));
            }
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FTPFile[] listFiles() throws Exception {
        FTPClient client = null;
        try {
            FTPFile[] fTPFileArray;
            client = this.connector.createFtpClient(this.endpoint);
            FTPListParseEngine engine = client.initiateListParsing();
            FTPFile[] files = null;
            ArrayList<FTPFile> v = new ArrayList<FTPFile>();
            while (engine.hasNext() && !this.getLifecycleState().isStopping()) {
                files = engine.getNext(25);
                if (files == null || files.length == 0) {
                    fTPFileArray = files;
                    return fTPFileArray;
                }
                for (FTPFile file : files) {
                    if (!file.isFile() || this.filenameFilter != null && !this.filenameFilter.accept(null, file.getName())) continue;
                    v.add(file);
                }
            }
            if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                throw new IOException("Failed to list files. Ftp error: " + client.getReplyCode());
            }
            fTPFileArray = v.toArray(new FTPFile[v.size()]);
            return fTPFileArray;
        }
        finally {
            if (client != null) {
                this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
            }
        }
    }

    protected void initializeMessageFactory() throws InitialisationException {
    }

    protected FtpMuleMessageFactory createMuleMessageFactory(FTPClient client) throws CreateException {
        FtpMuleMessageFactory factory = (FtpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setStreaming(this.connector.isStreaming());
        factory.setFtpClient(client);
        return factory;
    }

    protected void postProcess(FTPClient client, FTPFile file, MuleMessage message) throws Exception {
        if (!client.deleteFile(file.getName())) {
            throw new IOException(MessageFormat.format("Failed to delete file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted processed file " + file.getName()));
        }
        if (this.connector.isStreaming() && !client.completePendingCommand()) {
            throw new IOException(MessageFormat.format("Failed to complete a pending command. Retrieveing file {0}. Ftp error: {1}", file.getName(), client.getReplyCode()));
        }
    }

    protected void doConnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        FTPClient client = null;
        try {
            client = this.connector.createFtpClient(this.endpoint);
            client.sendNoOp();
            client.logout();
            client.disconnect();
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            block13: {
                try {
                    if (client != null) {
                        this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug((Object)("Failed to release ftp client " + client), (Throwable)e);
                }
            }
        }
        return retryContext;
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    private final class FtpWork
    implements Work {
        private final String name;
        private final FTPFile file;

        private FtpWork(String name, FTPFile file) {
            this.name = name;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FTPClient client = null;
            MuleMessage muleMessage = null;
            try {
                MuleMessage finalMessage;
                FTPClient finalClient = client = FtpMessageReceiver.this.connector.createFtpClient(FtpMessageReceiver.this.endpoint);
                FtpMessageReceiver.this.currentFiles.add(this.name);
                if (!FtpMessageReceiver.this.connector.validateFile(this.file)) {
                    return;
                }
                FtpMuleMessageFactory muleMessageFactory = FtpMessageReceiver.this.createMuleMessageFactory(finalClient);
                muleMessage = finalMessage = muleMessageFactory.create(this.file, FtpMessageReceiver.this.endpoint.getEncoding());
                ExecutionTemplate executionTemplate = FtpMessageReceiver.this.createExecutionTemplate();
                executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                    public MuleEvent process() throws Exception {
                        FtpMessageReceiver.this.routeMessage(finalMessage);
                        return null;
                    }
                });
                FtpMessageReceiver.this.postProcess(finalClient, this.file, finalMessage);
            }
            catch (MessagingException e) {
                if (!e.causedRollback()) {
                    try {
                        FtpMessageReceiver.this.postProcess(client, this.file, muleMessage);
                    }
                    catch (Exception e1) {
                        FtpMessageReceiver.this.logger.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                FtpMessageReceiver.this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
            finally {
                if (client != null) {
                    try {
                        FtpMessageReceiver.this.connector.releaseFtp(FtpMessageReceiver.this.endpoint.getEndpointURI(), client);
                    }
                    catch (Exception e) {
                        FtpMessageReceiver.this.logger.error((Object)e);
                    }
                }
                FtpMessageReceiver.this.currentFiles.remove(this.name);
                FtpMessageReceiver.this.scheduledFiles.remove(this.name);
            }
        }

        public void release() {
        }
    }
}

