/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.ResolverException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.registry.TypeBasedTransformerResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.types.SimpleDataType;

@SmallTest
public class TypeBasedTransformerResolverTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
    private DataType<Object> dataTypeA = new SimpleDataType(A.class);
    private DataType<Object> dataTypeB = new SimpleDataType(B.class);
    private DataType<Object> dataTypeC = new SimpleDataType(C.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleConfiguration.useExtendedTransformations()).thenReturn((Object)false);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
    }

    @Test
    public void doesNotFailIfCannotResolveType() throws ResolverException, TransformerException {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        ArrayList transformers = new ArrayList();
        Mockito.when((Object)muleRegistry.lookupTransformers(this.dataTypeA, this.dataTypeB)).thenReturn(transformers);
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        Transformer resolvedTransformer = resolver.resolve(this.dataTypeA, this.dataTypeB);
        Assert.assertNull((Object)resolvedTransformer);
    }

    @Test
    public void resolvesTypeWithOneMatchingTransformer() throws ResolverException, TransformerException {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Transformer aToBConverter = this.createMockConverter(this.dataTypeA, this.dataTypeB);
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        transformers.add(aToBConverter);
        Mockito.when((Object)muleRegistry.lookupTransformers(this.dataTypeA, this.dataTypeB)).thenReturn(transformers);
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        Transformer resolvedTransformer = resolver.resolve(this.dataTypeA, this.dataTypeB);
        Assert.assertEquals((Object)aToBConverter, (Object)resolvedTransformer);
    }

    @Test
    public void resolvesTypeWithTwoMatchingTransformer() throws ResolverException, TransformerException {
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Transformer aToBConverter = this.createMockConverter(1, this.dataTypeA, this.dataTypeB);
        Transformer betterAToBConverter = this.createMockConverter(2, this.dataTypeA, this.dataTypeB);
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        transformers.add(aToBConverter);
        transformers.add(betterAToBConverter);
        Mockito.when((Object)muleRegistry.lookupTransformers(this.dataTypeA, this.dataTypeB)).thenReturn(transformers);
        TypeBasedTransformerResolver resolver = new TypeBasedTransformerResolver();
        resolver.setMuleContext(this.muleContext);
        Transformer resolvedTransformer = resolver.resolve(this.dataTypeA, this.dataTypeB);
        Assert.assertEquals((Object)betterAToBConverter, (Object)resolvedTransformer);
    }

    private Transformer createMockConverter(DataType returnType, DataType ... sourceTypes) {
        Transformer converter = (Transformer)Mockito.mock(MockConverter.class);
        ((Transformer)Mockito.doReturn((Object)returnType).when((Object)converter)).getReturnDataType();
        ((Transformer)Mockito.doReturn(Arrays.asList(sourceTypes)).when((Object)converter)).getSourceDataTypes();
        return converter;
    }

    private Transformer createMockConverter(int weight, DataType returnType, DataType ... sourceTypes) {
        MockConverter converter = (MockConverter)Mockito.mock(MockConverter.class);
        ((MockConverter)Mockito.doReturn((Object)returnType).when((Object)converter)).getReturnDataType();
        ((MockConverter)Mockito.doReturn(Arrays.asList(sourceTypes)).when((Object)converter)).getSourceDataTypes();
        ((MockConverter)Mockito.doReturn((Object)weight).when((Object)converter)).getPriorityWeighting();
        return converter;
    }

    private static interface MockConverter
    extends Transformer,
    DiscoverableTransformer {
    }

    public static class C {
        private final String value;

        public C(String value) {
            this.value = value;
        }
    }

    public static class B {
        private final String value;

        public B(String value) {
            this.value = value;
        }
    }

    public static class A {
        private final String value;

        public A(String value) {
            this.value = value;
        }
    }
}

