/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.routing.SimpleCollectionAggregator;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class SimpleCollectionAggregatorTestCase
extends AbstractMuleContextTestCase {
    public SimpleCollectionAggregatorTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testAggregateMultipleEvents() throws Exception {
        MuleSession session1 = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        session1.setProperty("key1", (Serializable)((Object)"value1"));
        MuleSession session2 = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        session1.setProperty("key1", (Serializable)((Object)"value1NEW"));
        session1.setProperty("key2", (Serializable)((Object)"value2"));
        MuleSession session3 = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        session1.setProperty("key3", (Serializable)((Object)"value3"));
        Service testService = SimpleCollectionAggregatorTestCase.getTestService("test", Apple.class);
        Assert.assertNotNull((Object)testService);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        SensingNullMessageProcessor sensingMessageProcessor = this.getSensingNullMessageProcessor();
        router.setListener((MessageProcessor)sensingMessageProcessor);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        message1.setCorrelationGroupSize(3);
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, (FlowConstruct)testService, session1);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, endpoint, (FlowConstruct)testService, session2);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, endpoint, (FlowConstruct)testService, session3);
        Assert.assertNull((Object)router.process((MuleEvent)event1));
        Assert.assertNull((Object)router.process((MuleEvent)event2));
        Assert.assertNull((Object)router.process((MuleEvent)event3));
        Assert.assertNotNull((Object)sensingMessageProcessor.event);
        MuleMessage nextMessage = sensingMessageProcessor.event.getMessage();
        Assert.assertNotNull((Object)nextMessage);
        Assert.assertTrue((boolean)(nextMessage instanceof MuleMessageCollection));
        Assert.assertTrue((boolean)(nextMessage.getPayload() instanceof List));
        List payload = (List)nextMessage.getPayload();
        Assert.assertEquals((long)3L, (long)payload.size());
        Object[] results = new String[3];
        results = payload.toArray(results);
        Arrays.sort(results);
        Assert.assertEquals((Object)"test event A", (Object)results[0]);
        Assert.assertEquals((Object)"test event B", (Object)results[1]);
        Assert.assertEquals((Object)"test event C", (Object)results[2]);
        Assert.assertEquals((long)3L, (long)sensingMessageProcessor.event.getSession().getPropertyNamesAsSet().size());
        Assert.assertEquals((Object)"value1NEW", (Object)sensingMessageProcessor.event.getSession().getProperty("key1"));
        Assert.assertEquals((Object)"value2", (Object)sensingMessageProcessor.event.getSession().getProperty("key2"));
        Assert.assertEquals((Object)"value3", (Object)sensingMessageProcessor.event.getSession().getProperty("key3"));
    }

    @Test
    public void testAggregateSingleEvent() throws Exception {
        MuleSession session = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        Service testService = SimpleCollectionAggregatorTestCase.getTestService("test", Apple.class);
        Assert.assertNotNull((Object)testService);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        SensingNullMessageProcessor sensingMessageProcessor = this.getSensingNullMessageProcessor();
        router.setListener((MessageProcessor)sensingMessageProcessor);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message1.setCorrelationGroupSize(1);
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, endpoint, (FlowConstruct)testService);
        MuleEvent resultEvent = router.process((MuleEvent)event1);
        Assert.assertNull((Object)resultEvent);
        Assert.assertNotNull((Object)sensingMessageProcessor.event);
        MuleMessage nextMessage = sensingMessageProcessor.event.getMessage();
        Assert.assertNotNull((Object)nextMessage);
        Assert.assertTrue((boolean)(nextMessage instanceof MuleMessageCollection));
        Assert.assertTrue((boolean)(nextMessage.getPayload() instanceof List));
        List payload = (List)nextMessage.getPayload();
        Assert.assertEquals((long)1L, (long)payload.size());
        Assert.assertEquals((Object)"test event A", payload.get(0));
    }

    @Test
    public void testAggregateMessageCollections() throws Exception {
        MuleSession session = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        Service testService = SimpleCollectionAggregatorTestCase.getTestService("test", Apple.class);
        Assert.assertNotNull((Object)testService);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        DefaultMuleMessage message4 = new DefaultMuleMessage((Object)"test event D", muleContext);
        DefaultMessageCollection messageCollection1 = new DefaultMessageCollection(muleContext);
        DefaultMessageCollection messageCollection2 = new DefaultMessageCollection(muleContext);
        messageCollection1.addMessage((MuleMessage)message1);
        messageCollection1.addMessage((MuleMessage)message2);
        messageCollection2.addMessage((MuleMessage)message3);
        messageCollection2.addMessage((MuleMessage)message4);
        messageCollection1.setCorrelationGroupSize(2);
        messageCollection1.setCorrelationId(messageCollection1.getUniqueId());
        messageCollection2.setCorrelationGroupSize(2);
        messageCollection2.setCorrelationId(messageCollection1.getUniqueId());
        InboundEndpoint endpoint = MuleTestUtils.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)messageCollection1, endpoint, (FlowConstruct)testService);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)messageCollection2, endpoint, (FlowConstruct)testService);
        Assert.assertNull((Object)router.process((MuleEvent)event1));
        MuleEvent resultEvent = router.process((MuleEvent)event2);
        Assert.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        List payload = (List)resultMessage.getPayload();
        Assert.assertEquals((long)2L, (long)payload.size());
        Assert.assertEquals((Object)"test event A", ((List)payload.get(0)).get(0));
        Assert.assertEquals((Object)"test event B", ((List)payload.get(0)).get(1));
        Assert.assertEquals((Object)"test event C", ((List)payload.get(1)).get(0));
        Assert.assertEquals((Object)"test event D", ((List)payload.get(1)).get(1));
    }
}

