/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.GraphTransformerResolver;

@SmallTest
public class GraphTransformerResolverTest {
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    private static final DataType INPUT_STREAM_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"INPUT_STREAM_DATA_TYPE");
    private static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");

    @BeforeClass
    public static void setupDataTypes() {
        ((DataType)Mockito.doReturn((Object)true).when((Object)XML_DATA_TYPE)).isCompatibleWith(XML_DATA_TYPE);
        ((DataType)Mockito.doReturn(XML_CLASS.class).when((Object)XML_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)JSON_DATA_TYPE)).isCompatibleWith(JSON_DATA_TYPE);
        ((DataType)Mockito.doReturn(JSON_CLASS.class).when((Object)JSON_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)INPUT_STREAM_DATA_TYPE)).isCompatibleWith(INPUT_STREAM_DATA_TYPE);
        ((DataType)Mockito.doReturn(INPUT_STREAM_CLASS.class).when((Object)INPUT_STREAM_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)STRING_DATA_TYPE)).isCompatibleWith(STRING_DATA_TYPE);
        ((DataType)Mockito.doReturn(STRING_CLASS.class).when((Object)STRING_DATA_TYPE)).getType();
    }

    @Test
    public void ignoresTransformerAdded() {
        Transformer xmlToJson = this.createMockTransformer(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.edgeSet().size());
    }

    @Test
    public void ignoresTransformerRemoved() {
        Transformer xmlToJson = this.createMockTransformer(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.edgeSet().size());
    }

    @Test
    public void processesConverterAdded() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)1, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
    }

    @Test
    public void ignoresConverterAddedTwice() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)1, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
    }

    @Test
    public void processesConverterAddedWithMultipleSourceTypes() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        junit.framework.Assert.assertEquals((int)3, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)INPUT_STREAM_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE));
    }

    @Test
    public void processesConverterRemoved() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.edgeSet().size());
    }

    @Test
    public void ignoresRemovingConverterThatWasNeverAdded() {
        Transformer xmlToJson = this.createMockConverter(1, JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer betterXmlToJson = this.createMockConverter(2, JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)1, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
    }

    @Test
    public void processesConverterRemovedWithMultipleSourceTypes() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertEquals((int)0, (int)graphResolver.graph.edgeSet().size());
    }

    @Test
    public void multipleConvertersFromSameSourceToResultTypes() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer betterXmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
        this.assertContainsTransformer(graphResolver.graph.edgesOf((Object)JSON_DATA_TYPE), xmlToJson);
        this.assertContainsTransformer(graphResolver.graph.edgesOf((Object)JSON_DATA_TYPE), betterXmlToJson);
    }

    @Test
    public void removesFirstDuplicateConverterAdded() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer betterXmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        Set transformationEdges = graphResolver.graph.edgesOf((Object)JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformationEdges.size());
        this.assertContainsTransformer(transformationEdges, betterXmlToJson);
    }

    @Test
    public void removesSecondDuplicateConverterAdded() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer betterXmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        Set transformationEdges = graphResolver.graph.edgesOf((Object)JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformationEdges.size());
        this.assertContainsTransformer(transformationEdges, xmlToJson);
    }

    @Test
    public void multipleConvertersFromDifferentSourceToSameResultTypes() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer objectToJson = this.createMockConverter(JSON_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(objectToJson, TransformerResolver.RegistryAction.ADDED);
        junit.framework.Assert.assertEquals((int)3, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)INPUT_STREAM_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE));
    }

    @Test
    public void removeFirstAddedConverterWithDifferentSourceToSameResultTypes() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer objectToJson = this.createMockConverter(JSON_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(objectToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)INPUT_STREAM_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)1, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE));
    }

    @Test
    public void removeSecondAddedConverterWithDifferentSourceToSameResultTypes() {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer objectToJson = this.createMockConverter(JSON_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(objectToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(objectToJson, TransformerResolver.RegistryAction.REMOVED);
        junit.framework.Assert.assertEquals((int)2, (int)graphResolver.graph.vertexSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsVertex((Object)XML_DATA_TYPE));
        junit.framework.Assert.assertEquals((int)1, (int)graphResolver.graph.edgeSet().size());
        junit.framework.Assert.assertTrue((boolean)graphResolver.graph.containsEdge((Object)XML_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)XML_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)INPUT_STREAM_DATA_TYPE, (Object)JSON_DATA_TYPE));
        junit.framework.Assert.assertFalse((boolean)graphResolver.graph.containsEdge((Object)JSON_DATA_TYPE, (Object)INPUT_STREAM_DATA_TYPE));
    }

    @Test
    public void noTransformerFromSourceDataTypeFound() throws ResolverException {
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        Transformer transformer = graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertNull((Object)transformer);
    }

    @Test
    public void noTransformerToReturnDataTypeFound() throws ResolverException {
        Transformer xmlToJson = this.createMockTransformer(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(XML_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
        junit.framework.Assert.assertNull((Object)transformer);
    }

    @Test
    public void noTransformerFound() throws ResolverException {
        DataType mockStringDataType = (DataType)Mockito.mock(DataType.class);
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, mockStringDataType);
        junit.framework.Assert.assertNull((Object)transformer);
    }

    @Test
    public void resolvesDirectTransformation() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "xmlToJson", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((Object)xmlToJson, (Object)transformer);
    }

    @Test
    public void resolvesMultipleDirectTransformationAddingBetterTransformerFirst() throws ResolverException {
        Transformer betterXmlToJson = this.createMockConverter(2, JSON_DATA_TYPE, "betterXmlToJson", XML_DATA_TYPE);
        Transformer xmlToJson = this.createMockConverter(1, JSON_DATA_TYPE, "xmlToJson", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((Object)betterXmlToJson, (Object)transformer);
    }

    @Test
    public void resolvesMultipleDirectTransformationAddingBetterTransformerLast() throws ResolverException {
        Transformer betterXmlToJson = this.createMockConverter(2, JSON_DATA_TYPE, "betterXmlToJson", XML_DATA_TYPE);
        Transformer xmlToJson = this.createMockConverter(1, JSON_DATA_TYPE, "xmlToJson", XML_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((Object)betterXmlToJson, (Object)transformer);
    }

    @Test
    public void resolvesTransformationChain() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertTrue((boolean)(transformer instanceof CompositeConverter));
        CompositeConverter compositeConverter = (CompositeConverter)transformer;
        junit.framework.Assert.assertEquals((int)2, (int)compositeConverter.chain.size());
        junit.framework.Assert.assertEquals((Object)inputStreamToXml, compositeConverter.chain.get(0));
        junit.framework.Assert.assertEquals((Object)xmlToJson, compositeConverter.chain.get(1));
    }

    @Test
    public void cachesResolvedTransformer() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Transformer transformer2 = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertSame((Object)transformer1, (Object)transformer2);
    }

    @Test
    public void resolvesTransformationChainWithMultipleEdgesFromSource() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(1, JSON_DATA_TYPE, "xmlToJson", XML_DATA_TYPE);
        Transformer betterXmlToJson = this.createMockConverter(2, JSON_DATA_TYPE, "betterXmlToJson", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(1, XML_DATA_TYPE, "inputStreamToXml", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertTrue((boolean)(transformer instanceof CompositeConverter));
        CompositeConverter chain = (CompositeConverter)transformer;
        junit.framework.Assert.assertEquals((int)2, (int)chain.chain.size());
        junit.framework.Assert.assertEquals((Object)inputStreamToXml, chain.chain.get(0));
        junit.framework.Assert.assertEquals((Object)betterXmlToJson, chain.chain.get(1));
    }

    @Test
    public void resolvesTransformationChainWithMultipleEdgesToResult() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(1, JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(1, XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        Transformer mockBetterTransformerinputStreamToXml = this.createMockConverter(2, XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(mockBetterTransformerinputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertTrue((boolean)(transformer instanceof CompositeConverter));
        CompositeConverter chain = (CompositeConverter)transformer;
        junit.framework.Assert.assertEquals((int)2, (int)chain.chain.size());
        junit.framework.Assert.assertEquals((Object)mockBetterTransformerinputStreamToXml, chain.chain.get(0));
        junit.framework.Assert.assertEquals((Object)xmlToJson, chain.chain.get(1));
    }

    @Test
    public void resolvesTransformationChainWithMultipleEdges() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(1, JSON_DATA_TYPE, "xmlToJson", XML_DATA_TYPE);
        Transformer betterXmlToJson = this.createMockConverter(2, JSON_DATA_TYPE, "betterXmlToJson", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(1, XML_DATA_TYPE, "inputStreamToXml", INPUT_STREAM_DATA_TYPE);
        Transformer mockBetterTransformerInputStreamToXml = this.createMockConverter(2, XML_DATA_TYPE, "mockBetterTransformerInputStreamToXml", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(mockBetterTransformerInputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterXmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertTrue((boolean)(transformer instanceof CompositeConverter));
        CompositeConverter chain = (CompositeConverter)transformer;
        junit.framework.Assert.assertEquals((int)2, (int)chain.chain.size());
        junit.framework.Assert.assertEquals((Object)mockBetterTransformerInputStreamToXml, chain.chain.get(0));
        junit.framework.Assert.assertEquals((Object)betterXmlToJson, chain.chain.get(1));
    }

    @Test
    public void clearsCacheWhenAddsTransformer() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "xmlToJson", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "inputStreamToXml", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotNull((Object)transformer1);
        Transformer xmlToString = this.createMockConverter(STRING_DATA_TYPE, "xmlToString", XML_DATA_TYPE);
        graphResolver.transformerChange(xmlToString, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer2 = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotSame((Object)transformer1, (Object)transformer2);
    }

    @Test
    public void clearsCacheWhenRemovesTransformer() throws ResolverException {
        Transformer xmlToJson = this.createMockConverter(JSON_DATA_TYPE, "", XML_DATA_TYPE);
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotNull((Object)transformer);
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.REMOVED);
        graphResolver.transformerChange(xmlToJson, TransformerResolver.RegistryAction.REMOVED);
        transformer = graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertNull((Object)transformer);
    }

    @Test
    public void lookupTransformersNoSourceInGraph() throws Exception {
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(JSON_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)transformers.size());
    }

    @Test
    public void lookupTransformersNoTargetInGraph() throws Exception {
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)transformers.size());
    }

    @Test
    public void lookupTransformersOneMatchingDirectTransformer() throws Exception {
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformers.size());
        junit.framework.Assert.assertEquals((Object)inputStreamToXml, transformers.get(0));
    }

    @Test
    public void lookupTransformersTwoMatchingDirectTransformers() throws Exception {
        Transformer inputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        Transformer betterInputStreamToXml = this.createMockConverter(XML_DATA_TYPE, "", INPUT_STREAM_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(betterInputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)2, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(inputStreamToXml));
        Assert.assertTrue((boolean)transformers.contains(betterInputStreamToXml));
    }

    @Test
    public void lookupTransformersMatchingNonDirectTransformers1() throws Exception {
        Transformer inputStreamToString = this.createMockConverter(STRING_DATA_TYPE, "inputStreamToString", INPUT_STREAM_DATA_TYPE);
        Transformer inputStreamToJson = this.createMockConverter(JSON_DATA_TYPE, "inputStreamToJson", INPUT_STREAM_DATA_TYPE);
        Transformer jsonToXml = this.createMockConverter(XML_DATA_TYPE, "jsonToXml", JSON_DATA_TYPE);
        Transformer stringToXml = this.createMockConverter(XML_DATA_TYPE, "stringToXml", STRING_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToString, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(jsonToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(stringToXml, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)2, (int)transformers.size());
        this.assertContainsCompositeTransformer(transformers, inputStreamToString, stringToXml);
        this.assertContainsCompositeTransformer(transformers, inputStreamToJson, jsonToXml);
    }

    @Test
    public void lookupTransformersMatchingNonDirectTransformers2() throws Exception {
        Transformer inputStreamToString = this.createMockConverter(STRING_DATA_TYPE, "inputStreamToString", INPUT_STREAM_DATA_TYPE);
        Transformer inputStreamToJson = this.createMockConverter(JSON_DATA_TYPE, "inputStreamToJson", INPUT_STREAM_DATA_TYPE);
        Transformer jsonToXml = this.createMockConverter(XML_DATA_TYPE, "jsonToXml", JSON_DATA_TYPE);
        Transformer stringToXml = this.createMockConverter(XML_DATA_TYPE, "stringToXml", STRING_DATA_TYPE);
        Transformer stringToJson = this.createMockConverter(JSON_DATA_TYPE, "stringToJson", STRING_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToString, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(jsonToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(stringToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(stringToJson, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)3, (int)transformers.size());
        this.assertContainsCompositeTransformer(transformers, inputStreamToString, stringToXml);
        this.assertContainsCompositeTransformer(transformers, inputStreamToJson, jsonToXml);
        this.assertContainsCompositeTransformer(transformers, inputStreamToString, stringToJson, jsonToXml);
    }

    @Test
    public void lookupTransformersMatchingNonDirectTransformers3() throws Exception {
        Transformer inputStreamToString = this.createMockConverter(STRING_DATA_TYPE, "inputStreamToString", INPUT_STREAM_DATA_TYPE);
        Transformer inputStreamToJson = this.createMockConverter(JSON_DATA_TYPE, "inputStreamToJson", INPUT_STREAM_DATA_TYPE);
        Transformer jsonToXml = this.createMockConverter(XML_DATA_TYPE, "jsonToXml", JSON_DATA_TYPE);
        Transformer jsonToString = this.createMockConverter(STRING_DATA_TYPE, "jsonToXml", JSON_DATA_TYPE);
        Transformer stringToXml = this.createMockConverter(XML_DATA_TYPE, "stringToXml", STRING_DATA_TYPE);
        Transformer stringToJson = this.createMockConverter(JSON_DATA_TYPE, "stringToJson", STRING_DATA_TYPE);
        GraphTransformerResolver graphResolver = new GraphTransformerResolver();
        graphResolver.transformerChange(inputStreamToString, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(jsonToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(jsonToString, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(stringToXml, TransformerResolver.RegistryAction.ADDED);
        graphResolver.transformerChange(stringToJson, TransformerResolver.RegistryAction.ADDED);
        List transformers = graphResolver.lookupTransformers(INPUT_STREAM_DATA_TYPE, XML_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)4, (int)transformers.size());
        this.assertContainsCompositeTransformer(transformers, inputStreamToString, stringToXml);
        this.assertContainsCompositeTransformer(transformers, inputStreamToJson, jsonToXml);
        this.assertContainsCompositeTransformer(transformers, inputStreamToString, stringToJson, jsonToXml);
        this.assertContainsCompositeTransformer(transformers, inputStreamToJson, jsonToString, stringToXml);
    }

    private void assertContainsCompositeTransformer(List<Transformer> transformers, Transformer ... composedTransformers) {
        for (Transformer transformer : transformers) {
            if (!(transformer instanceof CompositeConverter)) continue;
            CompositeConverter compositeConverter = (CompositeConverter)transformer;
            if (compositeConverter.chain.size() != composedTransformers.length) continue;
            boolean matches = true;
            for (int i = 0; i < composedTransformers.length - 1; ++i) {
                if (composedTransformers[i] == compositeConverter.chain.get(i)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return;
        }
        junit.framework.Assert.fail((String)("Transformer list does not contain a composite transformer with: " + composedTransformers));
    }

    private Transformer createMockTransformer(DataType returnType, String name, DataType ... sourceTypes) {
        Transformer transformer = name == null || name.isEmpty() ? (Transformer)Mockito.mock(Transformer.class) : (Transformer)Mockito.mock(Transformer.class, (String)name);
        ((Transformer)Mockito.doReturn((Object)returnType).when((Object)transformer)).getReturnDataType();
        ((Transformer)Mockito.doReturn(Arrays.asList(sourceTypes)).when((Object)transformer)).getSourceDataTypes();
        return transformer;
    }

    private Transformer createMockConverter(DataType returnType, String name, DataType ... sourceTypes) {
        MockConverter converter = name == null || name.isEmpty() ? (MockConverter)Mockito.mock(MockConverter.class) : (MockConverter)Mockito.mock(MockConverter.class, (String)name);
        ((MockConverter)Mockito.doReturn((Object)returnType).when((Object)converter)).getReturnDataType();
        ((MockConverter)Mockito.doReturn(Arrays.asList(sourceTypes)).when((Object)converter)).getSourceDataTypes();
        return converter;
    }

    private Transformer createMockConverter(int weight, DataType returnType, String name, DataType ... sourceTypes) {
        MockConverter converter = name == null || name.isEmpty() ? (MockConverter)Mockito.mock(MockConverter.class) : (MockConverter)Mockito.mock(MockConverter.class, (String)name);
        ((MockConverter)Mockito.doReturn((Object)returnType).when((Object)converter)).getReturnDataType();
        ((MockConverter)Mockito.doReturn(Arrays.asList(sourceTypes)).when((Object)converter)).getSourceDataTypes();
        ((MockConverter)Mockito.doReturn((Object)weight).when((Object)converter)).getPriorityWeighting();
        return converter;
    }

    private void assertContainsTransformer(Set<GraphTransformerResolver.TransformationEdge> transformationEdges, Transformer transformer) {
        for (GraphTransformerResolver.TransformationEdge edge : transformationEdges) {
            if (edge.getTransformer() != transformer) continue;
            return;
        }
        junit.framework.Assert.fail((String)String.format("Transformation edges %s do not contain expected transformer %s", transformationEdges, transformer));
    }

    private static interface MockConverter
    extends Transformer,
    Converter {
    }

    private static class STRING_CLASS {
        private STRING_CLASS() {
        }
    }

    private static class INPUT_STREAM_CLASS {
        private INPUT_STREAM_CLASS() {
        }
    }

    private static class JSON_CLASS {
        private JSON_CLASS() {
        }
    }

    private static class XML_CLASS {
        private XML_CLASS() {
        }
    }
}

