/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.mule.api.MuleContext;
import org.mule.api.transformer.DataType;
import org.mule.transformer.TestConverter;
import org.mule.transformer.TestTransformer;

public class TransformerBuilder {
    private DataType<?> returnDataType;
    private DataType<?> sourceDataType;
    private Object returnValue;
    private MuleContext muleContext;

    public TransformerBuilder to(DataType<?> returnDataType) {
        this.returnDataType = returnDataType;
        return this;
    }

    public TransformerBuilder from(DataType<?> sourceDataType) {
        this.sourceDataType = sourceDataType;
        return this;
    }

    public TransformerBuilder returning(Object returnValue) {
        this.returnValue = returnValue;
        return this;
    }

    public TransformerBuilder boundTo(MuleContext muleContext) {
        this.muleContext = muleContext;
        return this;
    }

    public TestTransformer build() {
        TestTransformer result = new TestTransformer();
        this.setUpTransformer(result);
        return result;
    }

    public TestConverter buildConverter(int weighting) {
        TestConverter result = new TestConverter();
        this.setUpTransformer(result);
        result.setPriorityWeighting(weighting);
        return result;
    }

    private void setUpTransformer(TestTransformer result) {
        result.registerSourceType(this.sourceDataType);
        result.setReturnDataType(this.returnDataType);
        result.setMuleContext(this.muleContext);
        result.setReturnValue(this.returnValue);
    }
}

