/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.store.MuleObjectStoreManager;
import org.mule.util.store.ObjectStorePartition;
import org.mule.util.store.PartitionedInMemoryObjectStore;
import org.mule.util.store.PartitionedObjectStoreWrapper;
import org.mule.util.store.PartitionedPersistentObjectStore;
import org.mule.util.store.QueuePersistenceObjectStore;
import org.mule.util.store.SimpleMemoryObjectStore;

public class ManagedStoresTestCase
extends AbstractMuleContextTestCase {
    public ManagedStoresTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        MuleObjectStoreManager manager = (MuleObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        manager.clearStoreCache();
    }

    @Test
    public void testInMemoryStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        muleContext.getRegistry().registerObject("_defaultInMemoryQueueStore", (Object)new SimpleMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("inMemoryPart1", false);
        Assert.assertTrue((boolean)(store instanceof PartitionedObjectStoreWrapper));
        ListableObjectStore baseStore = ((PartitionedObjectStoreWrapper)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof SimpleMemoryObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore"));
        this.testObjectStore(store);
        this.testObjectStoreExpiry(manager.getObjectStore("inMemoryExpPart1", false, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("inMemoryMaxPart1", false, 10, 10000, 200));
    }

    @Test
    public void testPersistentStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        QueuePersistenceObjectStore queueStore = new QueuePersistenceObjectStore(muleContext);
        queueStore.open();
        muleContext.getRegistry().registerObject("_defaultPersistentQueueStore", (Object)queueStore);
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("persistencePart1", true);
        Assert.assertTrue((boolean)(store instanceof PartitionedObjectStoreWrapper));
        ListableObjectStore baseStore = ((PartitionedObjectStoreWrapper)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof QueuePersistenceObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultPersistentQueueStore"));
        this.testObjectStore(store, false);
        this.testObjectStoreExpiry(manager.getObjectStore("persistenceExpPart1", true, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("persistenceMaxPart1", true, 10, 10000, 200));
    }

    @Test
    public void testPartitionableInMemoryStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        muleContext.getRegistry().registerObject("_defaultInMemoryQueueStore", (Object)new PartitionedInMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("inMemoryPart2", false);
        Assert.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof PartitionedInMemoryObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore"));
        this.testObjectStore(store);
        this.testObjectStoreExpiry(manager.getObjectStore("inMemoryExpPart2", false, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("inMemoryMaxPart2", false, 10, 10000, 200));
    }

    @Test
    public void testPartitionablePersistenceStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        PartitionedPersistentObjectStore partitionedStore = new PartitionedPersistentObjectStore(muleContext);
        partitionedStore.open();
        muleContext.getRegistry().registerObject("_defaultPersistentQueueStore", (Object)partitionedStore);
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("persistencePart2", true);
        Assert.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof PartitionedPersistentObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultPersistentQueueStore"));
        this.testObjectStore(store);
        this.testObjectStoreExpiry(manager.getObjectStore("persistenceExpPart2", true, -1, 1000, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore)manager.getObjectStore("persistenceMaxPart2", true, 10, 10000, 200));
    }

    private void testObjectStore(ListableObjectStore store) throws ObjectStoreException {
        this.testObjectStore(store, true);
    }

    private void testObjectStore(ListableObjectStore store, boolean removeReturnsObject) throws ObjectStoreException {
        Throwable e = null;
        store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)store.retrieve((Serializable)((Object)"key1")));
        Assert.assertTrue((boolean)store.contains((Serializable)((Object)"key1")));
        try {
            store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        }
        catch (ObjectAlreadyExistsException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
        Assert.assertEquals((long)1L, (long)store.allKeys().size());
        Assert.assertEquals((Object)"key1", store.allKeys().get(0));
        if (removeReturnsObject) {
            Assert.assertEquals((Object)"value1", (Object)store.remove((Serializable)((Object)"key1")));
        } else {
            Assert.assertNull((Object)store.remove((Serializable)((Object)"key1")));
        }
        Assert.assertFalse((boolean)store.contains((Serializable)((Object)"key1")));
        try {
            store.retrieve((Serializable)((Object)"key1"));
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
        try {
            store.remove((Serializable)((Object)"key1"));
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
    }

    private void testObjectStoreExpiry(ObjectStore objectStore) throws ObjectStoreException, InterruptedException {
        objectStore.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)objectStore.retrieve((Serializable)((Object)"key1")));
        Thread.sleep(2000L);
        Assert.assertFalse((String)"Object with key1 still exists.", (boolean)objectStore.contains((Serializable)((Object)"key1")));
    }

    private void testObjectStoreMaxEntries(ListableObjectStore objectStore) throws ObjectStoreException, InterruptedException {
        int i;
        for (i = 0; i < 100; ++i) {
            objectStore.store((Serializable)((Object)("key" + i)), (Serializable)((Object)("value" + i)));
            Assert.assertEquals((Object)("value" + i), (Object)objectStore.retrieve((Serializable)((Object)("key" + i))));
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)10L, (long)objectStore.allKeys().size());
        for (i = 90; i < 100; ++i) {
            Assert.assertTrue((String)("Checking that key" + i + " exists"), (boolean)objectStore.contains((Serializable)((Object)("key" + i))));
        }
    }
}

