/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.AsyncWorkListener;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.work.AbstractMuleEventWork;

public class AsyncInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Startable,
Stoppable {
    protected WorkManagerSource workManagerSource;
    protected boolean doThreading = true;
    protected WorkManager workManager;

    public AsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource) {
        this.workManagerSource = workManagerSource;
    }

    public AsyncInterceptingMessageProcessor(ThreadingProfile threadingProfile, String name, int shutdownTimeout) {
        this.doThreading = threadingProfile.isDoThreading();
        this.workManager = threadingProfile.createWorkManager(name, shutdownTimeout);
        this.workManagerSource = new WorkManagerSource(){

            @Override
            public WorkManager getWorkManager() throws MuleException {
                return AsyncInterceptingMessageProcessor.this.workManager;
            }
        };
    }

    @Override
    public void start() throws MuleException {
        if (this.workManager != null) {
            this.workManager.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.isProcessAsync(event)) {
            this.processNextAsync(event);
            return null;
        }
        MuleEvent response = this.processNext(event);
        return response;
    }

    protected MuleEvent processNextTimed(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        MuleEvent response = event.getFlowConstruct() != null ? new ProcessingTimeInterceptor(this.next, event.getFlowConstruct()).process(event) : this.processNext(event);
        return response;
    }

    protected boolean isProcessAsync(MuleEvent event) throws MessagingException {
        if (event.isSynchronous() || event.isTransacted()) {
            throw new MessagingException(CoreMessages.createStaticMessage("Unable to process a synchonrous event asyncronously"), event, (MessageProcessor)this);
        }
        return this.doThreading && !event.isSynchronous();
    }

    protected void processNextAsync(MuleEvent event) throws MuleException {
        try {
            this.workManagerSource.getWorkManager().scheduleWork(new AsyncMessageProcessorWorker(event), Long.MAX_VALUE, null, new AsyncWorkListener(this.next));
        }
        catch (Exception e) {
            new MessagingException(CoreMessages.errorSchedulingMessageProcessorForAsyncInvocation(this.next), event, e, this);
        }
    }

    class AsyncMessageProcessorWorker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWorker(MuleEvent event) {
            super(event);
        }

        @Override
        protected void doRun() {
            TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(AsyncInterceptingMessageProcessor.this.muleContext, new MuleTransactionConfig(), this.event.getFlowConstruct().getExceptionListener());
            try {
                executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                    @Override
                    public MuleEvent process() throws Exception {
                        try {
                            AsyncInterceptingMessageProcessor.this.processNextTimed(AsyncMessageProcessorWorker.this.event);
                        }
                        catch (MessagingException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new MessagingException(AsyncMessageProcessorWorker.this.event, e, AsyncInterceptingMessageProcessor.this.next);
                        }
                        return null;
                    }
                });
            }
            catch (MessagingException e) {
            }
            catch (Exception e) {
                AsyncInterceptingMessageProcessor.this.muleContext.getExceptionListener().handleException(e);
            }
        }
    }
}

