/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;

public class TransformerUtils {
    public static final String COMMA = ",";
    public static final Boolean DEFAULT_TRANSFORMER_ENFORCEMENT = Boolean.TRUE;
    private static Log logger = LogFactory.getLog(AbstractTransformer.class);

    public static void initialiseAllTransformers(List<Transformer> transformers) throws InitialisationException {
        if (transformers != null) {
            Iterator<Transformer> transformer = transformers.iterator();
            while (transformer.hasNext()) {
                transformer.next().initialise();
            }
        }
    }

    public static String toString(List<Transformer> transformers) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Transformer> transformer = transformers.iterator();
        while (transformer.hasNext()) {
            buffer.append(transformer.next().toString());
            if (!transformer.hasNext()) continue;
            buffer.append(" -> ");
        }
        return buffer.toString();
    }

    public static Transformer firstOrNull(List<Transformer> transformers) {
        if (transformers != null && 0 != transformers.size()) {
            return transformers.get(0);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSourceTypeSupportedByFirst(List<Transformer> transformers, Class clazz) {
        Transformer transformer = TransformerUtils.firstOrNull(transformers);
        if (null == transformer) return false;
        new DataTypeFactory();
        if (!transformer.isSourceDataTypeSupported(DataTypeFactory.create(clazz))) return false;
        return true;
    }

    protected static List<Transformer> getTransformersFromSource(TransformerSource source) {
        try {
            List<Transformer> transformers = source.getTransformers();
            TransformerUtils.initialiseAllTransformers(transformers);
            return transformers;
        }
        catch (MuleException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Transformer> getDefaultInboundTransformers(final TransportServiceDescriptor serviceDescriptor, final ImmutableEndpoint endpoint) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            @Override
            public List<Transformer> getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createInboundTransformers(endpoint);
            }
        });
    }

    public static List<Transformer> getDefaultResponseTransformers(final TransportServiceDescriptor serviceDescriptor, final ImmutableEndpoint endpoint) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            @Override
            public List<Transformer> getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createResponseTransformers(endpoint);
            }
        });
    }

    public static List<Transformer> getDefaultOutboundTransformers(final TransportServiceDescriptor serviceDescriptor, final ImmutableEndpoint endpoint) {
        return TransformerUtils.getTransformersFromSource(new TransformerSource(){

            @Override
            public List<Transformer> getTransformers() throws TransportFactoryException {
                return serviceDescriptor.createOutboundTransformers(endpoint);
            }
        });
    }

    public static List<Transformer> getTransformers(String names, MuleContext muleContext) throws DefaultMuleException {
        if (null != names) {
            LinkedList<Transformer> transformers = new LinkedList<Transformer>();
            StringTokenizer st = new StringTokenizer(names, COMMA);
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                Transformer transformer = muleContext.getRegistry().lookupTransformer(key);
                if (transformer == null) {
                    throw new DefaultMuleException(CoreMessages.objectNotRegistered("Transformer", key));
                }
                transformers.add(transformer);
            }
            return transformers;
        }
        return null;
    }

    public static void checkTransformerReturnClass(Transformer transformer, Object value) throws TransformerException {
        if (value == null || value instanceof NullPayload && transformer instanceof AbstractTransformer && ((AbstractTransformer)transformer).isAllowNullReturn()) {
            return;
        }
        if (transformer.getReturnDataType() != null) {
            if (transformer.getReturnDataType() != null) {
                DataType<?> dt = DataTypeFactory.create(value.getClass());
                if (!transformer.getReturnDataType().isCompatibleWith(dt)) {
                    throw new TransformerException(CoreMessages.transformUnexpectedType(dt, transformer.getReturnDataType()), transformer);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The transformed value is of expected type. Type is: " + ClassUtils.getSimpleName(value.getClass())));
            }
        }
    }

    protected static interface TransformerSource {
        public List<Transformer> getTransformers() throws TransportFactoryException;
    }
}

