/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.InitiatorEncryptionToken;
import org.apache.cxf.ws.security.policy.model.InitiatorSignatureToken;
import org.apache.cxf.ws.security.policy.model.InitiatorToken;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.RecipientEncryptionToken;
import org.apache.cxf.ws.security.policy.model.RecipientSignatureToken;
import org.apache.cxf.ws.security.policy.model.RecipientToken;
import org.apache.cxf.ws.security.policy.model.SymmetricAsymmetricBindingBase;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class AsymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private InitiatorToken initiatorToken;
    private InitiatorSignatureToken initiatorSignatureToken;
    private InitiatorEncryptionToken initiatorEncryptionToken;
    private RecipientToken recipientToken;
    private RecipientSignatureToken recipientSignatureToken;
    private RecipientEncryptionToken recipientEncryptionToken;

    public AsymmetricBinding(SPConstants version, PolicyBuilder b) {
        super(version, b);
    }

    public InitiatorToken getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setInitiatorToken(InitiatorToken initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    public InitiatorSignatureToken getInitiatorSignatureToken() {
        return this.initiatorSignatureToken;
    }

    public void setInitiatorSignatureToken(InitiatorSignatureToken initiatorSignatureToken) {
        this.initiatorSignatureToken = initiatorSignatureToken;
    }

    public InitiatorEncryptionToken getInitiatorEncryptionToken() {
        return this.initiatorEncryptionToken;
    }

    public void setInitiatorEncryptionToken(InitiatorEncryptionToken initiatorEncryptionToken) {
        this.initiatorEncryptionToken = initiatorEncryptionToken;
    }

    public RecipientToken getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(RecipientToken recipientToken) {
        this.recipientToken = recipientToken;
    }

    public RecipientSignatureToken getRecipientSignatureToken() {
        return this.recipientSignatureToken;
    }

    public void setRecipientSignatureToken(RecipientSignatureToken recipientSignatureToken) {
        this.recipientSignatureToken = recipientSignatureToken;
    }

    public RecipientEncryptionToken getRecipientEncryptionToken() {
        return this.recipientEncryptionToken;
    }

    public void setRecipientEncryptionToken(RecipientEncryptionToken recipientEncryptionToken) {
        this.recipientEncryptionToken = recipientEncryptionToken;
    }

    public QName getRealName() {
        return this.constants.getAsymmetricBinding();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getAsymmetricBinding();
    }

    public PolicyComponent normalize() {
        return this;
    }

    public Policy getPolicy() {
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        if (this.getInitiatorToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getInitiatorToken());
        }
        if (this.getInitiatorSignatureToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getInitiatorSignatureToken());
        }
        if (this.getInitiatorEncryptionToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getInitiatorEncryptionToken());
        }
        if (this.getRecipientToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getRecipientToken());
        }
        if (this.getRecipientSignatureToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getRecipientSignatureToken());
        }
        if (this.getRecipientEncryptionToken() != null) {
            all.addPolicyComponent((PolicyComponent)this.getRecipientEncryptionToken());
        }
        if (this.isIncludeTimestamp()) {
            all.addPolicyComponent((PolicyComponent)new PrimitiveAssertion(SP12Constants.INCLUDE_TIMESTAMP));
        }
        if (this.getLayout() != null) {
            all.addPolicyComponent((PolicyComponent)this.getLayout());
        }
        ea.addPolicyComponent((PolicyComponent)all);
        Policy pc = p.normalize(this.builder.getPolicyRegistry(), true);
        if (pc instanceof Policy) {
            return pc;
        }
        p = new Policy();
        p.addPolicyComponent((PolicyComponent)pc);
        return p;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        AlgorithmSuite algorithmSuite;
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, SPConstants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
        if (this.initiatorToken == null && this.initiatorSignatureToken == null) {
            throw new RuntimeException("InitiatorToken or InitiatorSignatureToken is not set");
        }
        if (this.initiatorToken != null) {
            this.initiatorToken.serialize(writer);
        }
        if (this.initiatorSignatureToken != null) {
            this.initiatorSignatureToken.serialize(writer);
        }
        if (this.initiatorEncryptionToken != null) {
            this.initiatorEncryptionToken.serialize(writer);
        }
        if (this.recipientToken == null && this.recipientSignatureToken == null) {
            throw new RuntimeException("RecipientToken or RecipientSignatureToken is not set");
        }
        if (this.recipientToken != null) {
            this.recipientToken.serialize(writer);
        }
        if (this.recipientSignatureToken != null) {
            this.recipientSignatureToken.serialize(writer);
        }
        if (this.recipientEncryptionToken != null) {
            this.recipientEncryptionToken.serialize(writer);
        }
        if ((algorithmSuite = this.getAlgorithmSuite()) == null) {
            throw new RuntimeException("AlgorithmSuite is not set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, "IncludeTimestamp", namespaceURI);
            writer.writeEndElement();
        }
        if (SPConstants.ProtectionOrder.EncryptBeforeSigning.equals((Object)this.getProtectionOrder())) {
            writer.writeStartElement(prefix, SPConstants.ProtectionOrder.EncryptBeforeSigning.toString(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isSignatureProtection()) {
            writer.writeStartElement(prefix, "EncryptSignature", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isTokenProtection()) {
            writer.writeStartElement(prefix, "ProtectTokens", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeStartElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

