/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.xml;

import de.odysseus.staxon.util.EventWriterDelegate;
import de.odysseus.staxon.xml.PrettyXMLWhitespaceHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class PrettyXMLEventWriter
extends EventWriterDelegate {
    private final PrettyXMLWhitespaceHandler handler;

    public PrettyXMLEventWriter(XMLEventWriter writer) {
        this(writer, "\t", "\n");
    }

    public PrettyXMLEventWriter(XMLEventWriter writer, String indentation, String newline) {
        super(writer);
        this.handler = new PrettyXMLWhitespaceHandler(writer, indentation, newline);
    }

    @Override
    public void setParent(XMLEventWriter parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 7: {
                this.handler.preStartDocument();
                super.add(event);
                this.handler.postStartDocument();
                break;
            }
            case 8: {
                this.handler.preEndDocument();
                super.add(event);
                this.handler.postEndDocument();
            }
            case 1: {
                this.handler.preStartElement();
                super.add(event);
                this.handler.postStartElement();
                break;
            }
            case 2: {
                this.handler.preEndElement();
                super.add(event);
                this.handler.postEndElement();
                break;
            }
            case 4: 
            case 12: {
                this.handler.preCharacters();
                super.add(event);
                this.handler.postCharacters();
                break;
            }
            case 5: {
                this.handler.preComment();
                super.add(event);
                this.handler.postComment();
                break;
            }
            case 3: {
                this.handler.preProcessingInstruction();
                super.add(event);
                this.handler.postProcessingInstruction();
                break;
            }
            default: {
                super.add(event);
            }
        }
    }
}

