/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.MultiMap;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFAState
extends State {
    public static final int INITIAL_NUM_TRANSITIONS = 4;
    public static final int PREDICTED_ALT_UNSET = -2;
    public DFA dfa;
    protected List<Transition> transitions = new ArrayList<Transition>(4);
    protected int k;
    protected int acceptStateReachable = -2;
    protected boolean resolvedWithPredicates = false;
    public boolean abortedDueToRecursionOverflow = false;
    protected boolean abortedDueToMultipleRecursiveAlts = false;
    protected int cachedHashCode;
    protected int cachedUniquelyPredicatedAlt = -2;
    public int minAltInConfigurations = Integer.MAX_VALUE;
    public boolean atLeastOneConfigurationHasAPredicate = false;
    public OrderedHashSet<NFAConfiguration> nfaConfigurations = new OrderedHashSet();
    public List<NFAConfiguration> configurationsWithLabeledEdges = new ArrayList<NFAConfiguration>();
    protected Set<NFAConfiguration> closureBusy = new HashSet<NFAConfiguration>();
    protected OrderedHashSet<Label> reachableLabels;

    public DFAState(DFA dFA) {
        this.dfa = dFA;
    }

    public void reset() {
        this.configurationsWithLabeledEdges = null;
        this.closureBusy = null;
        this.reachableLabels = null;
    }

    @Override
    public Transition transition(int n) {
        return this.transitions.get(n);
    }

    @Override
    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    @Override
    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public int addTransition(DFAState dFAState, Label label) {
        this.transitions.add(new Transition(label, (State)dFAState));
        return this.transitions.size() - 1;
    }

    public Transition getTransition(int n) {
        return this.transitions.get(n);
    }

    public void removeTransition(int n) {
        this.transitions.remove(n);
    }

    public void addNFAConfiguration(NFAState nFAState, NFAConfiguration nFAConfiguration) {
        Label label;
        if (this.nfaConfigurations.contains(nFAConfiguration)) {
            return;
        }
        this.nfaConfigurations.add(nFAConfiguration);
        if (nFAConfiguration.alt < this.minAltInConfigurations) {
            this.minAltInConfigurations = nFAConfiguration.alt;
        }
        if (nFAConfiguration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
            this.atLeastOneConfigurationHasAPredicate = true;
        }
        this.cachedHashCode += nFAConfiguration.state + nFAConfiguration.alt;
        if (nFAState.transition[0] != null && !(label = nFAState.transition[0].label).isEpsilon() && !label.isSemanticPredicate()) {
            this.configurationsWithLabeledEdges.add(nFAConfiguration);
            if (nFAState.transition[1] == null) {
                nFAConfiguration.singleAtomTransitionEmanating = true;
            }
            this.addReachableLabel(label);
        }
    }

    public NFAConfiguration addNFAConfiguration(NFAState nFAState, int n, NFAContext nFAContext, SemanticContext semanticContext) {
        NFAConfiguration nFAConfiguration = new NFAConfiguration(nFAState.stateNumber, n, nFAContext, semanticContext);
        this.addNFAConfiguration(nFAState, nFAConfiguration);
        return nFAConfiguration;
    }

    protected void addReachableLabel(Label label) {
        IntSet intSet;
        if (this.reachableLabels == null) {
            this.reachableLabels = new OrderedHashSet();
        }
        if (this.reachableLabels.contains(label)) {
            return;
        }
        IntSet intSet2 = intSet = label.getSet();
        int n = this.reachableLabels.size();
        for (int i = 0; i < n; ++i) {
            Label label2 = this.reachableLabels.get(i);
            if (!Label.intersect(label, label2)) continue;
            IntSet intSet3 = label2.getSet();
            IntSet intSet4 = intSet3.and(intSet);
            this.reachableLabels.set(i, new Label(intSet4));
            IntSet intSet5 = intSet3.subtract(intSet);
            if (!intSet5.isNil()) {
                Label label3 = new Label(intSet5);
                this.reachableLabels.add(label3);
            }
            if ((intSet2 = intSet.subtract(intSet3)).isNil()) break;
            intSet = intSet2;
        }
        if (!intSet2.isNil()) {
            Label label4 = new Label(intSet2);
            this.reachableLabels.add(label4);
        }
    }

    public OrderedHashSet getReachableLabels() {
        return this.reachableLabels;
    }

    public void setNFAConfigurations(OrderedHashSet<NFAConfiguration> orderedHashSet) {
        this.nfaConfigurations = orderedHashSet;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            return super.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object object) {
        DFAState dFAState = (DFAState)object;
        return this.nfaConfigurations.equals(dFAState.nfaConfigurations);
    }

    public int getUniquelyPredictedAlt() {
        if (this.cachedUniquelyPredicatedAlt != -2) {
            return this.cachedUniquelyPredicatedAlt;
        }
        int n = -1;
        int n2 = this.nfaConfigurations.size();
        for (int i = 0; i < n2; ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            if (nFAConfiguration.resolved) continue;
            if (n == -1) {
                n = nFAConfiguration.alt;
                continue;
            }
            if (nFAConfiguration.alt == n) continue;
            return -1;
        }
        this.cachedUniquelyPredicatedAlt = n;
        return n;
    }

    public int getUniqueAlt() {
        int n = -1;
        int n2 = this.nfaConfigurations.size();
        for (int i = 0; i < n2; ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            if (n == -1) {
                n = nFAConfiguration.alt;
                continue;
            }
            if (nFAConfiguration.alt == n) continue;
            return -1;
        }
        return n;
    }

    public Set getDisabledAlternatives() {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        int n = this.nfaConfigurations.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            if (!nFAConfiguration.resolved) continue;
            linkedHashSet.add(Utils.integer(nFAConfiguration.alt));
        }
        return linkedHashSet;
    }

    protected Set getNonDeterministicAlts() {
        int n = this.dfa.getUserMaxLookahead();
        if (n > 0 && n == this.k) {
            return this.getAltSet();
        }
        if (this.abortedDueToMultipleRecursiveAlts || this.abortedDueToRecursionOverflow) {
            return this.getAltSet();
        }
        return this.getConflictingAlts();
    }

    protected Set<Integer> getConflictingAlts() {
        NFAConfiguration nFAConfiguration;
        int n;
        int n2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n3 = this.nfaConfigurations.size();
        if (n3 <= 1) {
            return null;
        }
        MultiMap<Object, NFAConfiguration> multiMap = new MultiMap<Object, NFAConfiguration>();
        for (int i = 0; i < n3; ++i) {
            NFAConfiguration nFAConfiguration2 = this.nfaConfigurations.get(i);
            Iterator iterator = Utils.integer(nFAConfiguration2.state);
            multiMap.map(iterator, nFAConfiguration2);
        }
        Set set = multiMap.keySet();
        int n4 = 0;
        for (Integer n5 : set) {
            boolean bl = false;
            List list = (List)multiMap.get(n5);
            n2 = 0;
            int n6 = list.size();
            for (n = 0; n < n6 && n6 > 1; ++n) {
                nFAConfiguration = (NFAConfiguration)list.get(n);
                if (n2 == 0) {
                    n2 = nFAConfiguration.alt;
                    continue;
                }
                if (nFAConfiguration.alt == n2 || this.dfa.nfa.grammar.type == 1 && this.dfa.decisionNFAStartState.enclosingRule.name.equals("Tokens")) continue;
                ++n4;
                bl = true;
            }
            if (bl) continue;
            multiMap.put(n5, null);
        }
        if (n4 == 0) {
            return null;
        }
        for (Integer n5 : set) {
            List list = (List)multiMap.get(n5);
            int n7 = 0;
            if (list != null) {
                n7 = list.size();
            }
            for (n2 = 0; n2 < n7; ++n2) {
                NFAConfiguration nFAConfiguration3 = (NFAConfiguration)list.get(n2);
                for (n = n2 + 1; n < n7; ++n) {
                    nFAConfiguration = (NFAConfiguration)list.get(n);
                    if (nFAConfiguration3.alt == nFAConfiguration.alt || !nFAConfiguration3.context.conflictsWith(nFAConfiguration.context)) continue;
                    hashSet.add(Utils.integer(nFAConfiguration3.alt));
                    hashSet.add(Utils.integer(nFAConfiguration.alt));
                }
            }
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public Set getAltSet() {
        int n = this.nfaConfigurations.size();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            hashSet.add(Utils.integer(nFAConfiguration.alt));
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public Set getGatedSyntacticPredicatesInNFAConfigurations() {
        int n = this.nfaConfigurations.size();
        HashSet<SemanticContext> hashSet = new HashSet<SemanticContext>();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            SemanticContext semanticContext = nFAConfiguration.semanticContext.getGatedPredicateContext();
            if (semanticContext == null || !nFAConfiguration.semanticContext.isSyntacticPredicate()) continue;
            hashSet.add(nFAConfiguration.semanticContext);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public SemanticContext getGatedPredicatesInNFAConfigurations() {
        SemanticContext semanticContext = null;
        int n = this.nfaConfigurations.size();
        for (int i = 0; i < n; ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            SemanticContext semanticContext2 = nFAConfiguration.semanticContext.getGatedPredicateContext();
            if (semanticContext2 == null) {
                return null;
            }
            if (!this.acceptState && nFAConfiguration.semanticContext.isSyntacticPredicate()) continue;
            semanticContext = semanticContext == null ? semanticContext2 : SemanticContext.or(semanticContext, semanticContext2);
        }
        if (semanticContext instanceof SemanticContext.TruePredicate) {
            return null;
        }
        return semanticContext;
    }

    public int getAcceptStateReachable() {
        return this.acceptStateReachable;
    }

    public void setAcceptStateReachable(int n) {
        this.acceptStateReachable = n;
    }

    public boolean isResolvedWithPredicates() {
        return this.resolvedWithPredicates;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new StringBuffer().append(this.stateNumber).append(":{").toString());
        for (int i = 0; i < this.nfaConfigurations.size(); ++i) {
            NFAConfiguration nFAConfiguration = this.nfaConfigurations.get(i);
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nFAConfiguration);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getLookaheadDepth() {
        return this.k;
    }

    public void setLookaheadDepth(int n) {
        this.k = n;
        if (n > this.dfa.max_k) {
            this.dfa.max_k = n;
        }
    }
}

