/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.builder;

import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.pvm.internal.builder.ActivityBuilder;
import org.jbpm.pvm.internal.builder.CompositeExceptionHandlerBuilder;
import org.jbpm.pvm.internal.builder.EventBuilder;
import org.jbpm.pvm.internal.builder.FlowBuilder;
import org.jbpm.pvm.internal.builder.TimerBuilder;
import org.jbpm.pvm.internal.builder.UnresolvedFlow;
import org.jbpm.pvm.internal.builder.VariableBuilder;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeBuilder {
    protected CompositeElementImpl compositeElement;

    public abstract ProcessDefinitionImpl endProcess();

    protected abstract void addUnresolvedFlow(UnresolvedFlow var1);

    protected abstract void setProcessDefinitionInitial(ActivityImpl var1);

    protected ActivityImpl createActivity() {
        return this.compositeElement.createActivity();
    }

    public EventImpl createEvent(String eventName) {
        return this.compositeElement.createEvent(eventName);
    }

    public CompositeBuilder variable(String name) {
        return this.startVariable(name).endVariable();
    }

    public CompositeBuilder variable(String name, String type) {
        return this.startVariable(name).type(type).endVariable();
    }

    public TimerBuilder startTimer() {
        return new TimerBuilder(this, null);
    }

    public TimerBuilder startTimer(String eventName) {
        return new TimerBuilder(this, eventName);
    }

    public VariableBuilder startVariable(String name) {
        return new VariableBuilder(this).name(name);
    }

    public ActivityBuilder startActivity() {
        return this.startActivity((String)null);
    }

    public ActivityBuilder startActivity(String activityName) {
        return new ActivityBuilder(this, activityName);
    }

    public ActivityBuilder startActivity(Descriptor activityDescriptor) {
        return this.startActivity(null, activityDescriptor);
    }

    public ActivityBuilder startActivity(String activityName, Descriptor activityDescriptor) {
        if (activityDescriptor == null) {
            throw new RuntimeException("activityDescriptor is null");
        }
        ActivityBuilder activityBuilder = new ActivityBuilder(this, activityName);
        activityBuilder.activity.setActivityBehaviourDescriptor(activityDescriptor);
        return activityBuilder;
    }

    public ActivityBuilder startActivity(ActivityBehaviour activityBehaviour) {
        return this.startActivity(null, activityBehaviour);
    }

    public ActivityBuilder startActivity(String activityName, ActivityBehaviour activityBehaviour) {
        if (activityBehaviour == null) {
            throw new RuntimeException("activity is null");
        }
        ActivityBuilder activityBuilder = new ActivityBuilder(this, activityName);
        activityBuilder.activity.setActivityBehaviour(activityBehaviour);
        return activityBuilder;
    }

    public ActivityBuilder startActivity(Class<? extends ActivityBehaviour> activityClass) {
        return this.startActivity(null, new ObjectDescriptor(activityClass));
    }

    public ActivityBuilder startActivity(String activityName, Class<? extends ActivityBehaviour> activityClass) {
        return this.startActivity(activityName, new ObjectDescriptor(activityClass));
    }

    public EventBuilder startEvent(String eventName) {
        return new EventBuilder(this, eventName);
    }

    public CompositeExceptionHandlerBuilder startExceptionHandler(Class<? extends Throwable> exceptionType) {
        return new CompositeExceptionHandlerBuilder(this, exceptionType);
    }

    public CompositeBuilder property(String name, String value) {
        return this.property(new StringDescriptor(name, value));
    }

    public CompositeBuilder property(Descriptor descriptor) {
        this.compositeElement.addProperty(descriptor);
        return this;
    }

    public CompositeBuilder endActivity() {
        throw new JbpmException("calling endActivity on a processBuilder is invalid");
    }

    public FlowBuilder startFlow(String to) {
        throw new JbpmException("calling startFlow on a processBuilder is invalid");
    }
}

