/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.builder;

import org.jbpm.api.listener.EventListener;
import org.jbpm.pvm.internal.builder.ActivityBuilder;
import org.jbpm.pvm.internal.builder.ObservableBuilder;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;

public class FlowBuilder
extends ObservableBuilder {
    protected ActivityBuilder activityBuilder;
    protected TransitionImpl transition;

    public FlowBuilder(ActivityBuilder activityBuilder, TransitionImpl transition) {
        super(transition, "take");
        this.activityBuilder = activityBuilder;
        this.transition = transition;
    }

    public FlowBuilder name(String name) {
        this.transition.setName(name);
        return this;
    }

    public FlowBuilder expr(String expression) {
        return this;
    }

    public FlowBuilder listener(EventListener eventListener) {
        this.addListener(eventListener);
        return this;
    }

    public FlowBuilder listener(EventListener eventListener, boolean propagation) {
        this.addListener(eventListener, propagation);
        return this;
    }

    public FlowBuilder listener(Descriptor descriptor) {
        this.addListener(descriptor);
        return this;
    }

    public FlowBuilder listener(Descriptor descriptor, boolean propagation) {
        this.addListener(descriptor, propagation);
        return this;
    }

    public FlowBuilder property(String name, String value) {
        StringDescriptor descriptor = new StringDescriptor(name, value);
        this.transition.addProperty(descriptor);
        return this;
    }

    public ActivityBuilder endFlow() {
        return this.activityBuilder;
    }
}

