/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.logging;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class AccessibleLog4jLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
Serializable {
    private static final long serialVersionUID = 6182834493563598289L;
    final transient Logger logger;
    static final String FQCN = AccessibleLog4jLoggerAdapter.class.getName();
    final boolean traceCapable;

    AccessibleLog4jLoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
        this.traceCapable = this.isTraceCapable();
    }

    private boolean isTraceCapable() {
        try {
            this.logger.isTraceEnabled();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.traceCapable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    @Override
    public void trace(String msg) {
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object[] argArray) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object[] argArray) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object[] argArray) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object[] argArray) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String msg) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object[] argArray) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, t);
    }

    @Override
    public void log(Marker marker, String callerFQCN, int level, String msg, Object[] argArray, Throwable t) {
        Level log4jLevel;
        switch (level) {
            case 0: {
                log4jLevel = this.traceCapable ? Level.TRACE : Level.DEBUG;
                break;
            }
            case 10: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case 20: {
                log4jLevel = Level.INFO;
                break;
            }
            case 30: {
                log4jLevel = Level.WARN;
                break;
            }
            case 40: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + level + " is not recognized.");
            }
        }
        this.logger.log(callerFQCN, (Priority)log4jLevel, (Object)msg, t);
    }
}

