/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.beans.ExceptionListener;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.annotation.Interceptor;
import org.ibeans.api.CallInterceptor;
import org.ibeans.api.IBeanStateData;
import org.ibeans.api.IBeansException;
import org.ibeans.impl.IBeanReader;
import org.ibeans.impl.InternalInvocationContext;
import org.ibeans.impl.LogResponsesInterceptor;
import org.ibeans.impl.NonIntegrationMethodsCallInterceptor;
import org.ibeans.impl.PopulateiBeansParamsInterceptor;
import org.ibeans.impl.ProcessErrorsInterceptor;
import org.ibeans.impl.StateCallInterceptor;
import org.ibeans.impl.support.util.TemplateParser;
import org.ibeans.spi.IBeansPlugin;

public class IntegrationBeanInvocationHandler
implements InvocationHandler,
Serializable {
    protected static transient Log logger = LogFactory.getLog(IntegrationBeanInvocationHandler.class);
    protected transient ExceptionListener exceptionListener;
    protected transient IBeanReader helper;
    protected transient TemplateParser parser = TemplateParser.createCurlyBracesStyleParser();
    protected transient LinkedList<CallInterceptor> defaultInterceptorList = new LinkedList();
    protected transient CallInterceptor invoker;
    protected transient Map<Method, List<CallInterceptor>> interceptorListCache = new HashMap<Method, List<CallInterceptor>>();
    protected IBeanStateData iBeanStateData;
    protected IBeansPlugin plugin;

    public IntegrationBeanInvocationHandler(Class ibean, IBeansPlugin plugin) throws IBeansException {
        if (ibean == null) {
            throw new IBeansException("IBean Interface is null");
        }
        this.plugin = plugin;
        this.helper = new IBeanReader(plugin);
        this.iBeanStateData = this.helper.readStateData(ibean);
        this.defaultInterceptorList.add(new NonIntegrationMethodsCallInterceptor());
        this.defaultInterceptorList.add(new PopulateiBeansParamsInterceptor(this.helper));
        this.defaultInterceptorList.add(new StateCallInterceptor());
        this.defaultInterceptorList.add(plugin.getResponseTransformInterceptor());
        this.defaultInterceptorList.add(new ProcessErrorsInterceptor());
        String logDirectory = System.getProperty("ibeans.log.responses");
        if (logDirectory != null) {
            this.defaultInterceptorList.add(new LogResponsesInterceptor(logDirectory));
        }
        plugin.addInterceptors(this.defaultInterceptorList);
        this.defaultInterceptorList.add(plugin.getIBeanInvoker());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.interceptorListCache.get(method) == null) {
            if (method.getAnnotation(Interceptor.class) != null) {
                Interceptor interceptorAnnotation = method.getAnnotation(Interceptor.class);
                ArrayList<CallInterceptor> interceptors = new ArrayList<CallInterceptor>();
                interceptors.addAll(this.defaultInterceptorList);
                interceptors.add(interceptors.size() - 3, (CallInterceptor)interceptorAnnotation.value().newInstance());
                this.interceptorListCache.put(method, interceptors);
            } else {
                this.interceptorListCache.put(method, this.defaultInterceptorList);
            }
        }
        InternalInvocationContext invocationContext = new InternalInvocationContext(this.iBeanStateData, proxy, method, args, this.exceptionListener, this.interceptorListCache.get(method), this.plugin);
        invocationContext.proceed();
        this.exceptionListener = invocationContext.getExceptionListener();
        if (invocationContext.isExceptionThrown()) {
            invocationContext.rethrowException();
        }
        if (invocationContext.getResult() == null) {
            return null;
        }
        return invocationContext.getResult();
    }
}

