/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import org.mule.transport.jms.ReusableQueueSessionWrapper;
import org.mule.transport.jms.ReusableSessionWrapper;
import org.mule.transport.jms.ReusableTopicSessionWrapper;

public class ReusableSessionWrapperFactory {
    public static Session createWrapper(Session session) {
        if (session instanceof TopicSession) {
            return new ReusableTopicSessionWrapper((TopicSession)session);
        }
        if (session instanceof QueueSession) {
            return new ReusableQueueSessionWrapper((QueueSession)session);
        }
        if (session instanceof Session) {
            return new ReusableSessionWrapper(session);
        }
        throw new IllegalArgumentException("session type " + session.getClass() + " no supported as reusable");
    }
}

