/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.model;

import java.util.HashMap;
import java.util.Map;
import org.scribe.model.Request;
import org.scribe.model.Verb;

public class OAuthRequest
extends Request {
    private static final String OAUTH_PREFIX = "oauth_";
    private Map<String, String> oauthParameters = new HashMap<String, String>();

    public OAuthRequest(Verb verb, String url) {
        super(verb, url);
    }

    public void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(this.checkKey(key), value);
    }

    private String checkKey(String key) {
        if (!key.startsWith(OAUTH_PREFIX)) {
            throw new IllegalArgumentException(String.format("OAuth parameters must start with '%s'", OAUTH_PREFIX));
        }
        return key;
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    @Override
    public String toString() {
        return String.format("@OAuthRequest(%s, %s)", new Object[]{this.getVerb(), this.getUrl()});
    }
}

