/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon;

import de.odysseus.staxon.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;

public abstract class AbstractXMLStreamScope
implements NamespaceContext {
    private final NamespaceContext parent;
    private final String prefix;
    private final String localName;
    private String defaultNamespace;
    private List<Pair<String, String>> prefixes;
    private AbstractXMLStreamScope lastChild;
    private boolean startTagClosed;

    public AbstractXMLStreamScope(String defaultNamespace) {
        this.parent = null;
        this.prefix = null;
        this.localName = null;
        this.defaultNamespace = defaultNamespace;
        this.startTagClosed = true;
    }

    public AbstractXMLStreamScope(NamespaceContext parent) {
        this.parent = parent;
        this.prefix = null;
        this.localName = null;
        this.defaultNamespace = parent.getNamespaceURI("");
        this.startTagClosed = true;
    }

    public AbstractXMLStreamScope(AbstractXMLStreamScope parent, String prefix, String localName) {
        this.parent = parent;
        this.prefix = prefix;
        this.localName = localName;
        this.startTagClosed = false;
        this.defaultNamespace = parent.getNamespaceURI("");
        parent.lastChild = this;
        parent.startTagClosed = true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isRoot() {
        return this.localName == null;
    }

    public AbstractXMLStreamScope getParent() {
        return this.isRoot() ? null : (AbstractXMLStreamScope)this.parent;
    }

    public AbstractXMLStreamScope getLastChild() {
        return this.lastChild;
    }

    public boolean isStartTagClosed() {
        return this.startTagClosed;
    }

    void setStartTagClosed(boolean startTagClosed) {
        this.startTagClosed = startTagClosed;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if (namespaceURI.equals(this.defaultNamespace)) {
            return "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        if (this.prefixes != null) {
            for (Pair<String, String> pair : this.prefixes) {
                if (!pair.getSecond().equals(namespaceURI)) continue;
                return pair.getFirst();
            }
        }
        return this.parent == null ? null : this.parent.getPrefix(namespaceURI);
    }

    public void setPrefix(String prefix, String namespaceURI) {
        if ("".equals(prefix)) {
            this.defaultNamespace = namespaceURI;
        } else {
            if ("xml".equals(namespaceURI)) {
                throw new IllegalArgumentException("Cannot redifine prefix: " + prefix);
            }
            if ("xmlns".equals(namespaceURI)) {
                throw new IllegalArgumentException("Cannot redifine prefix: " + prefix);
            }
            if (this.prefixes == null) {
                this.prefixes = new LinkedList<Pair<String, String>>();
            } else {
                Iterator<Pair<String, String>> iterator = this.prefixes.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().getFirst().equals(prefix)) continue;
                    iterator.remove();
                }
            }
            this.prefixes.add(new Pair<String, String>(prefix, namespaceURI));
        }
    }

    @Override
    public Iterator<String> getPrefixes(final String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return Arrays.asList("xml").iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return Arrays.asList("xmlns").iterator();
        }
        return new Iterator<String>(){
            int state = 0;
            String next = null;
            Iterator<Pair<String, String>> pairs;
            Iterator<?> above;

            private String next0() {
                switch (this.state) {
                    case 0: {
                        if (namespaceURI.equals(AbstractXMLStreamScope.this.defaultNamespace)) {
                            this.state = 1;
                            return "";
                        }
                    }
                    case 1: {
                        this.state = 1;
                        if (AbstractXMLStreamScope.this.prefixes != null) {
                            if (this.pairs == null) {
                                this.pairs = AbstractXMLStreamScope.this.prefixes.iterator();
                            }
                            while (this.pairs.hasNext()) {
                                Pair<String, String> p = this.pairs.next();
                                if (!namespaceURI.equals(p.getSecond())) continue;
                                return p.getFirst();
                            }
                        }
                    }
                    case 2: {
                        this.state = 2;
                        if (AbstractXMLStreamScope.this.parent == null) break;
                        if (this.above == null) {
                            this.above = AbstractXMLStreamScope.this.parent.getPrefixes(namespaceURI);
                        }
                        if (!this.above.hasNext()) break;
                        return this.above.next().toString();
                    }
                }
                this.state = -1;
                return null;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.next0();
                }
                return this.next != null;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove prefix");
            }
        };
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null");
        }
        if ("".equals(prefix)) {
            return this.defaultNamespace;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefixes != null) {
            for (Pair<String, String> pair : this.prefixes) {
                if (!pair.getFirst().equals(prefix)) continue;
                return pair.getSecond();
            }
        }
        return this.parent == null ? "" : this.parent.getNamespaceURI(prefix);
    }
}

