/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.event;

import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class SimpleXMLFilteredEventReader
extends EventReaderDelegate {
    private final EventFilter filter;
    private int currentEventType = -1;

    public SimpleXMLFilteredEventReader(XMLEventReader reader, EventFilter filter) {
        super(reader);
        this.filter = filter;
    }

    @Override
    public void setParent(XMLEventReader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.getParent().hasNext()) {
                if (this.filter.accept(this.getParent().peek())) {
                    return true;
                }
                this.getParent().nextEvent();
            }
            return false;
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        return this.hasNext() ? this.getParent().peek() : null;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.hasNext()) {
            XMLEvent event = this.getParent().nextEvent();
            this.currentEventType = event.getEventType();
            return event;
        }
        throw new XMLStreamException("no more events");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.currentEventType != 1) {
            throw new XMLStreamException("Expected start element event");
        }
        StringBuilder builder = null;
        String leadText = null;
        while (true) {
            XMLEvent event = this.nextEvent();
            String data = null;
            switch (event.getEventType()) {
                case 9: {
                    data = ((EntityReference)event).getName();
                    break;
                }
                case 4: 
                case 12: {
                    data = event.asCharacters().getData();
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    return builder == null ? (leadText == null ? "" : leadText) : builder.toString();
                }
                default: {
                    throw new XMLStreamException("Unexpected event type " + this.currentEventType, event.getLocation());
                }
            }
            if (data == null) continue;
            if (leadText == null) {
                leadText = data;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder(leadText);
            }
            builder.append(data);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent event;
        block6: while (true) {
            event = this.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    continue block6;
                }
                case 3: 
                case 5: 
                case 6: {
                    continue block6;
                }
                case 4: 
                case 12: {
                    if (!event.asCharacters().isWhiteSpace()) throw new XMLStreamException("Encountered non-whitespace text");
                    continue block6;
                }
                case 1: 
                case 2: {
                    return event;
                }
            }
            break;
        }
        throw new XMLStreamException("Encountered unexpected event: " + event.getEventType());
    }
}

