/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.work.MuleWorkManager;

public class DefaultMuleContextBuilderTestCase
extends AbstractMuleTestCase {
    @Test
    public void testBuildMuleContextDefault() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        MuleContext muleContext = builder.buildMuleContext();
        Assert.assertNotNull((Object)muleContext);
        Assert.assertEquals(DefaultMuleConfiguration.class, muleContext.getConfiguration().getClass());
        Assert.assertEquals(MuleContextLifecycleManager.class, muleContext.getLifecycleManager().getClass());
        Assert.assertEquals(ServerNotificationManager.class, muleContext.getNotificationManager().getClass());
        Assert.assertEquals(MuleWorkManager.class, muleContext.getWorkManager().getClass());
    }

    @Test
    public void testBuildMuleContextCustom() {
        DefaultMuleContextBuilder builder = new DefaultMuleContextBuilder();
        builder.setMuleConfiguration((MuleConfiguration)new MyMuleConfiguration());
        builder.setLifecycleManager((LifecycleManager)new MyLifeCycleManager());
        builder.setNotificationManager((ServerNotificationManager)new MyServerNotificationManager());
        builder.setWorkManager((WorkManager)new MyWorkManager(ThreadingProfile.DEFAULT_THREADING_PROFILE, "test"));
        MuleContext muleContext = builder.buildMuleContext();
        Assert.assertNotNull((Object)muleContext);
        Assert.assertEquals(MyMuleConfiguration.class, muleContext.getConfiguration().getClass());
        Assert.assertEquals(MyLifeCycleManager.class, muleContext.getLifecycleManager().getClass());
        Assert.assertEquals(MyServerNotificationManager.class, muleContext.getNotificationManager().getClass());
        Assert.assertEquals(MyWorkManager.class, muleContext.getWorkManager().getClass());
    }

    protected MuleContext createMuleContext() throws Exception {
        return null;
    }

    static class MyWorkManager
    extends MuleWorkManager {
        public MyWorkManager(ThreadingProfile profile, String name) {
            super(profile, name, 5000);
        }
    }

    static class MyServerNotificationManager
    extends ServerNotificationManager {
        MyServerNotificationManager() {
        }
    }

    static class MyMuleConfiguration
    extends DefaultMuleConfiguration {
        MyMuleConfiguration() {
        }
    }

    static class MyLifeCycleManager
    extends MuleContextLifecycleManager {
        MyLifeCycleManager() {
        }
    }
}

