/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DataTypeConversionResolver;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.TestConverter;
import org.mule.transformer.TestTransformer;
import org.mule.transformer.TransformerBuilder;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;

@SmallTest
public class DefaultMuleMessageTransformationTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext;
    private DataTypeConversionResolver conversionResolver;
    private static final DataType<Object> dataTypeB = new SimpleDataType(B.class);
    private static final DataType<Object> dataTypeC = new SimpleDataType(C.class);
    private static final DataType<Object> dataTypeD = new SimpleDataType(D.class);

    @Before
    public void setUp() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.conversionResolver = (DataTypeConversionResolver)Mockito.mock(DataTypeConversionResolver.class);
        Mockito.when((Object)this.muleContext.getDataTypeConverterResolver()).thenReturn((Object)this.conversionResolver);
    }

    @Test
    public void failsOnConverterWhenSourceAndReturnTypeDoesNotMatchAndThereIsNoImplicitConversion() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)converter1.wasExecuted());
    }

    @Test
    public void appliesImplicitConversionOnConverterWhenSourceAndReturnTypeDoesNotMatch() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        TestConverter converter2 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        Mockito.when((Object)this.conversionResolver.resolve((DataType)Mockito.any(DataType.class), Mockito.anyList())).thenReturn((Object)converter2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        Assert.assertTrue((boolean)converter1.wasExecuted());
        Assert.assertTrue((boolean)converter2.wasExecuted());
    }

    @Test
    public void appliesConverter() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof C));
        Assert.assertTrue((boolean)converter1.wasExecuted());
    }

    @Test
    public void skipsConverterThatDoesNotMatchWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof C));
        Assert.assertFalse((boolean)converter1.wasExecuted());
    }

    @Test
    public void failsTransformationUsingConverterWhenSourceAndReturnTypeDoesNotMatch2() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)converter1.wasExecuted());
        Assert.assertFalse((boolean)converter2.wasExecuted());
    }

    @Test
    public void appliesBothConverters() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        Assert.assertTrue((boolean)converter1.wasExecuted());
        Assert.assertTrue((boolean)converter2.wasExecuted());
    }

    @Test
    public void skipsFirstConverterAppliesSecond() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        Assert.assertFalse((boolean)converter1.wasExecuted());
        Assert.assertTrue((boolean)converter2.wasExecuted());
    }

    @Test
    public void skipBothConvertersButPayloadMatchesExpectedOutputType() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).buildConverter(1);
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        Assert.assertFalse((boolean)converter1.wasExecuted());
        Assert.assertFalse((boolean)converter2.wasExecuted());
    }

    @Test
    public void failsTransformerIgnoringNonMatchingConverter() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)converter2.wasExecuted());
    }

    @Test
    public void appliesTransformerSkipsConverter() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{transformer1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        Assert.assertTrue((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)converter2.wasExecuted());
    }

    @Test
    public void failsTransformerIgnoringMatchingConverter() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)converter2.wasExecuted());
    }

    @Test
    public void failsTransformerIgnoringMatchingConverterWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestConverter converter2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)converter2.wasExecuted());
    }

    @Test
    public void skipsConverterFailsOnTransformer() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)converter1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void appliesConverterFailsOnTransformer() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertTrue((boolean)converter1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void skipsConverterAppliesTransformer() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, transformer2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        Assert.assertFalse((boolean)converter1.wasExecuted());
        Assert.assertTrue((boolean)transformer2.wasExecuted());
    }

    @Test
    public void skipsConverterFailsOnTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        TestConverter converter1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).buildConverter(1);
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)converter1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void failsOnFirstTransformer() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void appliesFirstTransformerFailsOnSecondTransformer() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertTrue((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void failsOnFirstTransformerIgnoresSecondTransformer() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void failsOnFirstTransformerIgnoresSecondTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        TestTransformer transformer2 = new TransformerBuilder().from(dataTypeC).to(dataTypeD).returning(new D()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
        Assert.assertFalse((boolean)transformer2.wasExecuted());
    }

    @Test
    public void failsOnTransformerWhenSourceAndReturnTypeDoesNotMatch() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
    }

    @Test
    public void appliesTransformer() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{transformer1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof C));
        Assert.assertTrue((boolean)transformer1.wasExecuted());
    }

    @Test
    public void failsOnTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        TestTransformer transformer1 = new TransformerBuilder().from(dataTypeB).to(dataTypeC).returning(new C()).boundTo(this.muleContext).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer1.wasExecuted());
    }

    @Test
    public void failsWhenNoImplicitConversionAvailable() throws MuleException {
        TestTransformer transformer = new TransformerBuilder().from(DataTypeFactory.BYTE_ARRAY).to(DataTypeFactory.STRING).returning("bar").boundTo(this.muleContext).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)Mockito.any(DataType.class), Mockito.anyList())).thenReturn(null);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TEST", this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transformer.wasExecuted());
    }

    @Test
    public void appliesImplicitConversionWhenAvailable() throws MuleException {
        TestTransformer transformer = new TransformerBuilder().from(DataTypeFactory.BYTE_ARRAY).to(DataTypeFactory.STRING).returning("bar").boundTo(this.muleContext).build();
        TestConverter converter = new TransformerBuilder().from(DataTypeFactory.STRING).to(DataTypeFactory.BYTE_ARRAY).returning("bar".getBytes()).boundTo(this.muleContext).buildConverter(1);
        Mockito.when((Object)this.conversionResolver.resolve((DataType)Mockito.any(DataType.class), Mockito.anyList())).thenReturn((Object)converter);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TEST", this.muleContext);
        message.applyTransformers(null, new Transformer[]{transformer});
        Assert.assertEquals((Object)"bar", (Object)message.getPayload());
        Assert.assertTrue((boolean)transformer.wasExecuted());
        Assert.assertTrue((boolean)converter.wasExecuted());
    }

    private class D {
        private D() {
        }
    }

    private class C {
        private C() {
        }
    }

    private class B {
        private B() {
        }
    }

    private class A {
        private A() {
        }
    }
}

