/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.ObjectNameHelper;

public class EndpointURIEndpointBuilderTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testBuildInboundEndpoint() throws Exception {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        InboundEndpoint ep = endpointBuilder.buildInboundEndpoint();
        Assert.assertTrue((boolean)(ep instanceof InboundEndpoint));
        Assert.assertFalse((boolean)(ep instanceof OutboundEndpoint));
        Assert.assertNotNull((Object)ep.getTransformers());
        Assert.assertEquals((long)0L, (long)ep.getTransformers().size());
        Assert.assertNotNull((Object)ep.getResponseTransformers());
        Assert.assertEquals((long)0L, (long)ep.getResponseTransformers().size());
        this.testDefaultCommonEndpointAttributes((ImmutableEndpoint)ep);
    }

    @Test
    public void testBuildOutboundEndpoint() throws MuleException {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        OutboundEndpoint ep = endpointBuilder.buildOutboundEndpoint();
        Assert.assertFalse((boolean)(ep instanceof InboundEndpoint));
        Assert.assertTrue((boolean)(ep instanceof OutboundEndpoint));
        Assert.assertEquals((long)0L, (long)ep.getTransformers().size());
        Assert.assertNotNull((Object)ep.getResponseTransformers());
        Assert.assertEquals((long)0L, (long)ep.getResponseTransformers().size());
        this.testDefaultCommonEndpointAttributes((ImmutableEndpoint)ep);
    }

    protected void testDefaultCommonEndpointAttributes(ImmutableEndpoint ep) {
        Assert.assertEquals((Object)ep.getEndpointURI().getUri().toString(), (Object)"test://address");
        Assert.assertEquals((long)muleContext.getConfiguration().getDefaultResponseTimeout(), (long)ep.getResponseTimeout());
        Assert.assertTrue((String)("ep.getRetryPolicyTemplate() = " + ep.getRetryPolicyTemplate().getClass()), (boolean)(ep.getRetryPolicyTemplate() instanceof NoRetryPolicyTemplate));
        Assert.assertTrue((boolean)(ep.getTransactionConfig() instanceof MuleTransactionConfig));
        Assert.assertTrue((boolean)(ep.getTransactionConfig() instanceof MuleTransactionConfig));
        Assert.assertEquals(null, (Object)ep.getSecurityFilter());
        Assert.assertTrue((boolean)(ep.getConnector() instanceof TestConnector));
        Assert.assertEquals((Object)new ObjectNameHelper(muleContext).getEndpointName(ep.getEndpointURI()), (Object)ep.getName());
        Assert.assertFalse((boolean)ep.isDeleteUnacceptedMessages());
        Assert.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)ep.getEncoding());
        Assert.assertEquals(null, (Object)ep.getFilter());
        Assert.assertEquals((Object)"started", (Object)ep.getInitialState());
    }

    @Test
    public void testHasSetEncodingMethod() throws Exception {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        Assert.assertNotNull((Object)endpointBuilder.getClass().getMethod("setEncoding", String.class));
    }

    @Test
    public void testEndpointBuilderFromEndpoint() throws Exception {
        String uri = "test://address";
        InboundEndpoint endpoint = EndpointURIEndpointBuilderTestCase.getTestInboundEndpoint("endpoint.test.address", uri);
        SensingEndpointURIEndpointBuilder builder = new SensingEndpointURIEndpointBuilder((ImmutableEndpoint)endpoint);
        Assert.assertEquals((Object)uri, (Object)builder.getEndpointBuilder().getEndpoint().getUri().toString());
        Assert.assertEquals((Object)endpoint.getConnector(), (Object)builder.getConnector());
        Assert.assertEquals((Object)endpoint.getProperties(), (Object)builder.getProperties());
        Assert.assertEquals((Object)endpoint.getTransactionConfig(), (Object)builder.getTransactionConfig());
        Assert.assertEquals((Object)endpoint.isDeleteUnacceptedMessages(), (Object)builder.getDeleteUnacceptedMessages(builder.getConnector()));
        Assert.assertEquals((Object)endpoint.getInitialState(), (Object)builder.getInitialState(builder.getConnector()));
        Assert.assertEquals((long)endpoint.getResponseTimeout(), (long)builder.getResponseTimeout(builder.getConnector()));
        Assert.assertEquals((Object)endpoint.getSecurityFilter(), (Object)builder.getSecurityFilter());
        Assert.assertEquals((Object)endpoint.getRetryPolicyTemplate(), (Object)builder.getRetryPolicyTemplate(builder.getConnector()));
        Assert.assertEquals((Object)MessageExchangePattern.ONE_WAY, (Object)builder.getExchangePattern());
    }

    @Test
    public void testEndpointBuilderTransformersState() throws Exception {
        muleContext.getRegistry().registerObject("tran1", (Object)new StringAppendTransformer("1"));
        muleContext.getRegistry().registerObject("tran2", (Object)new StringAppendTransformer("2"));
        String uri = "test://address?transformers=tran1&responseTransformers=tran2";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        endpointBuilder.setTransformers(Collections.singletonList(new StringAppendTransformer("3")));
        endpointBuilder.setResponseTransformers(Collections.singletonList(new StringAppendTransformer("4")));
        InboundEndpoint endpoint = endpointBuilder.buildInboundEndpoint();
        Assert.assertEquals((long)3L, (long)endpoint.getMessageProcessors().size());
        Assert.assertEquals((long)2L, (long)endpoint.getResponseMessageProcessors().size());
        endpoint = endpointBuilder.buildInboundEndpoint();
        Assert.assertEquals((long)3L, (long)endpoint.getMessageProcessors().size());
        Assert.assertEquals((long)2L, (long)endpoint.getResponseMessageProcessors().size());
    }

    private static class SensingEndpointURIEndpointBuilder
    extends EndpointURIEndpointBuilder {
        public SensingEndpointURIEndpointBuilder(ImmutableEndpoint endpoint) {
            super(endpoint);
        }

        public MessageExchangePattern getExchangePattern() {
            return this.messageExchangePattern;
        }
    }
}

