/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.api.security.SecurityFilter;
import org.mule.api.transformer.Transformer;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.NullMessageProcessor;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.transformer.simple.InboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;

public class InboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    private static final String TEST_MESSAGE = "test";
    private InboundEndpoint endpoint;
    private SensingNullMessageProcessor inboundListener;
    private MuleMessage inMessage;
    private MuleEvent requestEvent;
    private MuleEvent responseEvent;
    private MuleEvent result;
    private static String RESPONSE_MESSAGE = "response-message";

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.inMessage = this.createTestRequestMessage();
        this.inboundListener = new SensingNullMessageProcessor();
    }

    @Test
    public void testDefaultFlowSync() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        Assert.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    @Test
    public void testDefaultFlowAsync() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(false);
        Assert.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    @Test
    public void testFilterAccept() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(new AbstractMessageProcessorTestCase.TestFilter(true), null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        Assert.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    @Test
    public void testFilterNotAccept() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(new AbstractMessageProcessorTestCase.TestFilter(false), null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        try {
            this.result = mpChain.process(this.requestEvent);
            Assert.fail((String)"Filter should have thrown a FilterException");
        }
        catch (FilterUnacceptedException filterUnacceptedException) {
            // empty catch block
        }
        this.assertMessageNotSent();
    }

    @Test
    public void testSecurityFilterAccept() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        Assert.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    @Test
    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        this.endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        RequestContext.setEvent((MuleEvent)this.requestEvent);
        try {
            this.result = mpChain.process(this.requestEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            this.requestEvent.getFlowConstruct().getExceptionListener().handleException((Exception)((Object)e), this.requestEvent);
        }
        Assert.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)401L, (long)securityNotificationListener.securityNotification.getAction());
        Assert.assertEquals((Object)securityNotificationListener.securityNotification.getResourceIdentifier(), (Object)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    @Test
    public void testFilterFirstThenSecurityFilter() throws Exception {
        TestSecurityFilter securityFilter = new TestSecurityFilter(false);
        this.endpoint = this.createTestInboundEndpoint(new AbstractMessageProcessorTestCase.TestFilter(false), (SecurityFilter)securityFilter, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        try {
            this.result = mpChain.process(this.requestEvent);
            Assert.fail((String)"Filter should have thrown a FilterException");
        }
        catch (FilterUnacceptedException filterUnacceptedException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)securityFilter.wasCalled());
        this.assertMessageNotSent();
    }

    @Test
    public void testMessagePropertyErrorMapping() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        this.responseEvent.getMessage().setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        Assert.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
        int status = (Integer)this.result.getMessage().getOutboundProperty("status", (Object)0);
        Assert.assertEquals((long)500L, (long)status);
    }

    @Test
    public void testResponseTransformerExceptionDetailAfterRequestFlowInterupt() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        this.responseEvent.getMessage().setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        RequestContext.setEvent((MuleEvent)this.requestEvent);
        try {
            this.result = mpChain.process(this.requestEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException staticMessageUnauthorisedException) {
            // empty catch block
        }
        this.assertMessageNotSent();
    }

    @Test
    public void testNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        Assert.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)801L, (long)listener.messageNotification.getAction());
        Assert.assertEquals((Object)this.endpoint.getEndpointURI().getUri().toString(), (Object)listener.messageNotification.getEndpoint());
        Assert.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        Assert.assertEquals((Object)this.inMessage.getPayload(), (Object)listener.messageNotification.getSource().getPayload());
    }

    @Test
    public void testTransformers() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, (Transformer)new InboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent(this.endpoint);
        this.responseEvent = this.createTestResponseEvent(this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSent(true);
        Assert.assertEquals((Object)(TEST_MESSAGE + InboundAppendTransformer.APPEND_STRING), (Object)this.inboundListener.sensedEvent.getMessageAsString());
        Assert.assertNotNull((Object)this.result);
        Assert.assertEquals((Object)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (Object)this.result.getMessage().getPayloadAsString());
    }

    @Test
    public void testObjectAwareInjection() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://myTestUri", muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new AbstractMessageProcessorTestCase.ObjectAwareProcessor());
        this.endpoint = endpointBuilder.buildInboundEndpoint();
        this.endpoint.setListener((MessageProcessor)new NullMessageProcessor());
        this.endpoint.setFlowConstruct((FlowConstruct)InboundEndpointTestCase.getTestService());
        this.endpoint.start();
        AbstractMessageProcessorTestCase.ObjectAwareProcessor objectAware = (AbstractMessageProcessorTestCase.ObjectAwareProcessor)this.endpoint.getMessageProcessors().get(0);
        Assert.assertEquals((Object)muleContext, (Object)objectAware.context);
        Assert.assertEquals((Object)this.endpoint, (Object)objectAware.endpoint);
        this.endpoint.stop();
    }

    protected MuleMessage createTestRequestMessage() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        return new DefaultMuleMessage((Object)TEST_MESSAGE, props, muleContext);
    }

    protected MuleEvent createTestRequestEvent(InboundEndpoint ep) throws Exception {
        return new DefaultMuleEvent(this.inMessage, ep, (FlowConstruct)InboundEndpointTestCase.getTestService(), InboundEndpointTestCase.getTestSession(null, muleContext));
    }

    protected MuleEvent createTestResponseEvent(InboundEndpoint ep) throws Exception {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)RESPONSE_MESSAGE, muleContext), ep, (FlowConstruct)InboundEndpointTestCase.getTestService(), InboundEndpointTestCase.getTestSession(null, muleContext));
    }

    protected MuleEvent assertMessageSent(boolean sync) throws MuleException {
        MuleEvent event = this.inboundListener.sensedEvent;
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)sync, (Object)event.getExchangePattern().hasResponse());
        Assert.assertNotNull((Object)event.getMessage());
        return event;
    }

    protected MuleEvent assertMessageSentSame(boolean sync) throws MuleException {
        this.assertMessageSent(sync);
        MuleEvent event = this.inboundListener.sensedEvent;
        Assert.assertEquals((Object)this.inMessage, (Object)event.getMessage());
        Assert.assertEquals((Object)TEST_MESSAGE, (Object)event.getMessageAsString());
        Assert.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
        return event;
    }

    protected void assertMessageNotSent() throws MuleException {
        MuleEvent event = this.inboundListener.sensedEvent;
        Assert.assertNull((Object)event);
    }

    private class SensingNullMessageProcessor
    implements MessageProcessor {
        MuleEvent sensedEvent;

        private SensingNullMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.sensedEvent = event;
            return InboundEndpointTestCase.this.responseEvent;
        }
    }
}

