/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.expression.MessagePayloadExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitBowlToFruitBasket;

public class PayloadExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testSimple() throws Exception {
        MessagePayloadExpressionEvaluator eval = new MessagePayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object result = eval.evaluate(null, (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result);
        result = eval.evaluate(null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testSimpleUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Assert.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("${payload:}"));
        Assert.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[payload:]"));
        Object result = muleContext.getExpressionManager().evaluate("#[payload:]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[payload:]", (MuleMessage)null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testWithTransform() throws Exception {
        MessagePayloadExpressionEvaluator eval = new MessagePayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object result = eval.evaluate("byte[]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof byte[]));
        Assert.assertEquals((Object)"test", (Object)new String((byte[])result));
        ByteArrayInputStream bais = new ByteArrayInputStream("test2".getBytes());
        result = eval.evaluate("java.lang.String", (MuleMessage)new DefaultMuleMessage((Object)bais, muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test2", (Object)result);
    }

    @Test
    public void testWithMoreComplexTransform() throws Exception {
        MessagePayloadExpressionEvaluator eval = new MessagePayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), muleContext);
        muleContext.getRegistry().registerTransformer((Transformer)new FruitBowlToFruitBasket());
        Object result = eval.evaluate("org.mule.tck.testmodels.fruit.FruitBasket", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof FruitBasket));
        FruitBasket fb = (FruitBasket)result;
        Assert.assertEquals((long)2L, (long)fb.getFruit().size());
        Assert.assertTrue((boolean)fb.hasBanana());
        Assert.assertTrue((boolean)fb.hasApple());
    }
}

