/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.enricher;

import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.enricher.MessageEnricher;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.simple.StringAppendTransformer;

public class MessageEnricherTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testEnrichHeaderWithPayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"test");
                return event;
            }
        });
        enricher.initialise();
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertEquals((Object)"test", (Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeaderWithHeader() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header1]", "#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                return event;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertEquals((Object)"test", (Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeadersMToN() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header1]", "#[header:myHeader1]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header2]", "#[header:myHeader2]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header3]", "#[header:myHeader3]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                event.getMessage().setOutboundProperty("header2", (Object)"test2");
                event.getMessage().setOutboundProperty("header3", (Object)"test3");
                return event;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertNull((Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test2", (Object)result.getOutboundProperty("myHeader2"));
        Assert.assertEquals((Object)"test3", (Object)result.getOutboundProperty("myHeader3"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeaderNestedEvaluator() throws Exception {
        muleContext.getRegistry().registerObject("appender", (Object)new StringAppendTransformer(" append"));
        MessageEnricher enricher = new MessageEnricher();
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[process:appender:#[header:header1]]", "#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                return event;
            }
        });
        MuleEvent event = MessageEnricherTestCase.getTestEvent("");
        RequestContext.setEvent((MuleEvent)event);
        Assert.assertEquals((Object)"test append", (Object)enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage().getOutboundProperty("myHeader"));
    }

    @Test
    public void testEnrichWithNullResponse() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertNull((Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }
}

