/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.exception.AbstractExceptionListener;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.mule.transaction.TransactionCoordination;

public abstract class TemplateMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private MessageProcessor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private String when;
    private boolean handleException;

    @Override
    public final MuleEvent handleException(Exception exception, MuleEvent event) {
        try {
            FlowConstruct flowConstruct = event.getFlowConstruct();
            this.fireNotification(exception);
            this.logException(exception);
            this.processStatistics(event);
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(exception));
            event = this.beforeRouting(exception, event);
            event = this.route(event, exception);
            this.processOutboundRouterStatistics(flowConstruct);
            event = this.afterRouting(exception, event);
            this.markExceptionAsHandledIfRequired(exception);
            if (event != null) {
                this.processReplyTo(event, exception);
                this.closeStream(event.getMessage());
                this.nullifyExceptionPayloadIfRequired(event);
            }
            return event;
        }
        catch (Exception e) {
            MessagingException messagingException = e instanceof MessagingException ? (MessagingException)e : new MessagingException(event, (Throwable)e);
            try {
                this.logger.error((Object)"Exception during exception strategy execution");
                this.logException(e);
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            catch (Exception ex) {
                // empty catch block
            }
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(messagingException));
            return event;
        }
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)exception).setHandled(true);
        }
    }

    protected void processReplyTo(MuleEvent event, Exception e) {
        try {
            this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
        }
    }

    protected void nullifyExceptionPayloadIfRequired(MuleEvent event) {
        if (this.handleException) {
            event.getMessage().setExceptionPayload(null);
        }
    }

    private void processStatistics(MuleEvent event) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    protected MuleEvent route(MuleEvent event, Exception t) {
        if (!this.getMessageProcessors().isEmpty()) {
            try {
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(t));
                MuleEvent result = this.configuredMessageProcessors.process(event);
                return result;
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        return event;
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        try {
            this.configuredMessageProcessors = defaultMessageProcessorChainBuilder.chain(this.getMessageProcessors()).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(MuleEvent event) {
        return this.acceptsAll() || this.muleContext.getExpressionManager().evaluateBoolean(this.when, event);
    }

    @Override
    public boolean acceptsAll() {
        return this.when == null;
    }

    protected MuleEvent afterRouting(Exception exception, MuleEvent event) {
        return event;
    }

    protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
        return event;
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }
}

