/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats.printers;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.StringTokenizer;
import org.mule.management.stats.printers.AbstractTablePrinter;
import org.mule.util.StringUtils;

public class HtmlTablePrinter
extends AbstractTablePrinter {
    public HtmlTablePrinter(Writer out) {
        super(out);
    }

    public HtmlTablePrinter(OutputStream out) {
        super(out);
    }

    @Override
    public void print(Collection stats) {
        int i;
        this.println("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        String[][] table = this.getTable(stats);
        boolean providerStats = false;
        this.println("<tr>");
        for (i = 0; i < table.length; ++i) {
            this.println("<td class=\"statistics\">" + table[i][0] + "</td>");
        }
        this.println("</tr>");
        for (i = 1; i < table[0].length; ++i) {
            this.println("<tr class=\"" + (i % 2 == 0 ? "darkline" : "clearline") + "\">");
            for (int j = 0; j < table.length; ++j) {
                if (j == 0) {
                    if (StringUtils.equals((String)table[1][i], (String)"-")) {
                        if (StringUtils.equals((String)table[j][i], (String)"By Provider")) {
                            this.println("<td class=\"statisticsrow\"><div class=\"tablesubheader\">" + table[j][i] + "</div></td>");
                            continue;
                        }
                        this.println("<td class=\"statisticsrow\"><div class=\"tableheader\">" + table[j][i] + "</div></td>");
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)table[j][i])) {
                        this.println("<td class=\"statisticsrow\">" + table[j][i] + "</td>");
                        continue;
                    }
                    this.println("<td class=\"statisticsrow\">&nbsp;</td>");
                    continue;
                }
                if (providerStats) {
                    this.println("<td class=\"statisticsrow\">" + this.getProviderStatsHtml(table[j][i]) + "</td>");
                    continue;
                }
                this.println("<td class=\"statisticsrow\">" + (StringUtils.equals((String)table[j][i], (String)"-") ? "" : table[j][i]) + "</td>");
            }
            this.println("</tr>");
            providerStats = StringUtils.equals((String)table[0][i], (String)"By Provider");
        }
        this.println("</table>");
    }

    protected String getProviderStatsHtml(String stats) {
        if (StringUtils.isBlank((String)stats) || "-".equals(stats)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<table>");
        StringTokenizer st = new StringTokenizer(stats, ";");
        if (st.countTokens() == 0) {
            buf.append("<tr><td class=\"statisticssubrow\">");
            int i = stats.indexOf("=");
            buf.append(stats.substring(0, i)).append(": ");
            buf.append("</td><td  class=\"statisticssubrow\">");
            buf.append(stats.substring(i + 1));
            buf.append("</td></tr>");
        } else {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                buf.append("<tr><td class=\"statisticssubrow\">");
                int i = token.indexOf("=");
                buf.append(token.substring(0, i)).append(": ");
                buf.append("</td><td class=\"statisticssubrow\">");
                buf.append(token.substring(i + 1));
                buf.append("</td></tr>");
            }
        }
        buf.append("</table>");
        return buf.toString();
    }
}

