/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.support;

import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.schema.elements.SchemaElement;

public class QNameConverter {
    public static String serialize(QName qname, IMarshallingContext ictx) throws JiBXException {
        String prefix;
        if (qname == null) {
            return null;
        }
        IXMLWriter ixw = ((MarshallingContext)ictx).getXmlWriter();
        int index = -1;
        String uri = qname.getUri();
        if (uri == null) {
            uri = "";
        }
        if ((prefix = qname.getPrefix()) != null) {
            int tryidx = ixw.getPrefixIndex(prefix);
            if (tryidx >= 0 && uri.equals(ixw.getNamespaceUri(tryidx))) {
                index = tryidx;
            } else if ("".equals(prefix)) {
                int depth = ictx.getStackDepth();
                for (int i = 0; i < depth; ++i) {
                    Object obj = ictx.getStackObject(i);
                    if (!(obj instanceof SchemaElement)) continue;
                    SchemaElement schema = (SchemaElement)obj;
                    String ens = schema.getEffectiveNamespace();
                    if (ens == schema.getTargetNamespace()) break;
                    return qname.getName();
                }
            }
        }
        if (index < 0) {
            String[][] nsss;
            if (uri == null) {
                uri = "";
            }
            String[] nss = ixw.getNamespaces();
            for (int i = 0; i < nss.length; ++i) {
                if (!nss[i].equals(uri)) continue;
                index = i;
                break;
            }
            if (index < 0 && (nsss = ixw.getExtensionNamespaces()) != null) {
                int base = nss.length;
                block2: for (int i = nsss.length - 1; i >= 0; --i) {
                    nss = nsss[i];
                    for (int j = 0; j < nss.length; ++j) {
                        if (!nss[j].equals(uri)) continue;
                        index = base + j;
                        for (int k = 0; k < i; ++k) {
                            index += nsss[k].length;
                        }
                        break block2;
                    }
                }
            }
        }
        if (index >= 0) {
            prefix = ixw.getNamespacePrefix(index);
            if (prefix == null) {
                throw new JiBXException("Namespace URI " + qname.getUri() + " cannot be used since it is not active");
            }
            if (prefix.length() > 0) {
                return prefix + ':' + qname.getName();
            }
            return qname.getName();
        }
        throw new JiBXException("Unknown namespace URI " + qname.getUri());
    }

    public static String serializeList(QName[] qnames, IMarshallingContext ictx) throws JiBXException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < qnames.length; ++i) {
            QName qname = qnames[i];
            if (qname == null) continue;
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(QNameConverter.serialize(qname, ictx));
        }
        return buff.toString();
    }

    public static void patchQNameNamespace(String uri, QName qname) {
        if (uri != null && qname != null && qname.getUri() == null) {
            qname.setUri(uri);
        }
    }
}

