/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import java.util.List;
import org.jbpm.api.IdentityService;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.identity.cmd.CreateGroupCmd;
import org.jbpm.pvm.internal.identity.cmd.CreateMembershipCmd;
import org.jbpm.pvm.internal.identity.cmd.CreateUserCmd;
import org.jbpm.pvm.internal.identity.cmd.DeleteGroupCmd;
import org.jbpm.pvm.internal.identity.cmd.DeleteMembershipCmd;
import org.jbpm.pvm.internal.identity.cmd.DeleteUserCmd;
import org.jbpm.pvm.internal.identity.cmd.FindGroupCmd;
import org.jbpm.pvm.internal.identity.cmd.FindGroupsCmd;
import org.jbpm.pvm.internal.identity.cmd.FindUserCmd;
import org.jbpm.pvm.internal.identity.cmd.FindUsersCmd;
import org.jbpm.pvm.internal.svc.AbstractServiceImpl;
import org.jbpm.pvm.internal.svc.FindGroupIds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityServiceImpl
extends AbstractServiceImpl
implements IdentityService {
    protected CommandService commandService;

    public void createUser(String userId, String givenName, String familyName) {
        this.commandService.execute(new CreateUserCmd(userId, givenName, familyName));
    }

    public void createUser(String userId, String givenName, String familyName, String businessEmail) {
        this.commandService.execute(new CreateUserCmd(userId, givenName, familyName, businessEmail));
    }

    public User findUserById(String userId) {
        return this.commandService.execute(new FindUserCmd(userId));
    }

    public List<User> findUsers() {
        return this.commandService.execute(new FindUsersCmd());
    }

    public void deleteUser(String userId) {
        this.commandService.execute(new DeleteUserCmd(userId));
    }

    public String createGroup(String groupName) {
        return this.commandService.execute(new CreateGroupCmd(groupName, null, null));
    }

    public String createGroup(String groupName, String groupType) {
        return this.commandService.execute(new CreateGroupCmd(groupName, groupType, null));
    }

    public String createGroup(String groupName, String groupType, String parentGroupId) {
        return this.commandService.execute(new CreateGroupCmd(groupName, groupType, parentGroupId));
    }

    public Group findGroupById(String groupId) {
        return this.commandService.execute(new FindGroupCmd(groupId));
    }

    public List<String> findGroupIdsByUser(String userId) {
        return this.commandService.execute(new FindGroupIds(userId));
    }

    public List<Group> findGroupsByUser(String userId) {
        return this.commandService.execute(new FindGroupsCmd(userId));
    }

    public List<Group> findGroupsByUserAndGroupType(String userId, String groupType) {
        return this.commandService.execute(new FindGroupsCmd(userId, groupType));
    }

    public void deleteGroup(String groupId) {
        this.commandService.execute(new DeleteGroupCmd(groupId));
    }

    public void createMembership(String userId, String groupId) {
        this.commandService.execute(new CreateMembershipCmd(userId, groupId, null));
    }

    public void createMembership(String userId, String groupId, String role) {
        this.commandService.execute(new CreateMembershipCmd(userId, groupId, role));
    }

    public void deleteMembership(String userId, String groupId, String role) {
        this.commandService.execute(new DeleteMembershipCmd(userId, groupId, role));
    }
}

