/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.naming;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.naming.CosNamingServiceMBean;

public class CosNamingService
implements CosNamingServiceMBean {
    private int m_port;
    private volatile boolean m_running;
    private Process m_process;
    private InputStreamConsumer m_output;
    private InputStreamConsumer m_error;
    private volatile Exception exception;

    public CosNamingService() {
        this(900);
    }

    public CosNamingService(int port) {
        this.m_port = port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            return;
        }
        final Logger logger = this.getLogger();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String home = CosNamingService.this.getJavaHomeBin();
                String command = (home == null ? "" : home) + "tnameserv -ORBInitialPort " + CosNamingService.this.getPort();
                try {
                    CosNamingService.this.m_process = Runtime.getRuntime().exec(command);
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Process created: " + CosNamingService.this.m_process);
                    }
                }
                catch (IOException x) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Could not create process", x);
                    }
                    CosNamingService.this.exception = x;
                    return;
                }
                CosNamingService.this.m_output = new InputStreamConsumer(CosNamingService.this.m_process.getInputStream());
                CosNamingService.this.m_error = new InputStreamConsumer(CosNamingService.this.m_process.getErrorStream());
                CosNamingService.this.m_output.start();
                CosNamingService.this.m_error.start();
                CosNamingService.this.m_running = true;
                try {
                    int result = CosNamingService.this.m_process.waitFor();
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Exit value is: " + result);
                    }
                    if (CosNamingService.this.isRunning()) {
                        CosNamingService.this.stop();
                        if (logger.isEnabledFor(20)) {
                            logger.info("Unexpected exception (maybe the port " + CosNamingService.this.getPort() + " is already in use)");
                        }
                    }
                }
                catch (InterruptedException x) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Process has been interrupted", x);
                    }
                    CosNamingService.this.stop();
                }
            }
        }, "CosNamingService Thread");
        thread.setDaemon(true);
        thread.start();
        while (!this.m_running && this.exception == null) {
            this.wait(10L);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("CosNamingService started");
        }
    }

    private String getJavaHomeBin() {
        String home = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.home");
            }
        });
        if (home != null && !home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        if (home != null) {
            home = home + "bin" + File.separator;
        }
        return home;
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.m_running = false;
        this.m_output.interrupt();
        this.m_error.interrupt();
        this.m_process.destroy();
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private class InputStreamConsumer
    extends Thread {
        private final InputStream m_stream;
        private final byte[] m_buffer = new byte[128];

        public InputStreamConsumer(InputStream stream) {
            super("Stream Consumer Thread");
            this.m_stream = new BufferedInputStream(stream);
            this.setDaemon(true);
        }

        public void run() {
            Logger logger = CosNamingService.this.getLogger();
            while (!this.isInterrupted()) {
                try {
                    int read = -1;
                    while ((read = this.m_stream.read(this.m_buffer)) >= 0) {
                        if (!logger.isEnabledFor(20)) continue;
                        logger.info(new String(this.m_buffer, 0, read));
                    }
                }
                catch (InterruptedIOException x) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (IOException x) {
                    if (!logger.isEnabledFor(20)) break;
                    logger.info("Error while consuming process stream", x);
                    break;
                }
            }
        }
    }
}

