/*
 * $Id: SftpMessageRequesterFactory.java 21125 2011-01-26 21:21:10Z dzapata $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.sftp;

import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.MessageRequester;
import org.mule.transport.AbstractMessageRequesterFactory;

public class SftpMessageRequesterFactory extends AbstractMessageRequesterFactory
{

    /** {@inheritDoc} */
    public MessageRequester create(InboundEndpoint endpoint) throws MuleException
    {
        return new SftpMessageRequester(endpoint);
    }
}
