/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(SequenceStyleGenerator.class);
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.identifierType = type;
        boolean forceTableUse = PropertiesHelper.getBoolean(FORCE_TBL_PARAM, params, false);
        String sequenceName = this.determineSequenceName(params, dialect);
        int initialValue = this.determineInitialValue(params);
        int incrementSize = this.determineIncrementSize(params);
        String optimizationStrategy = this.determineOptimizationStrategy(params, incrementSize);
        incrementSize = this.determineAdjustedIncrementSize(optimizationStrategy, incrementSize);
        if (dialect.supportsSequences() && !forceTableUse && "pooled".equals(optimizationStrategy) && !dialect.supportsPooledSequences()) {
            forceTableUse = true;
            log.info("Forcing table use for sequence-style generator due to pooled optimizer selection where db does not support pooled sequences");
        }
        this.databaseStructure = this.buildDatabaseStructure(type, params, dialect, forceTableUse, sequenceName, initialValue, incrementSize);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), incrementSize, PropertiesHelper.getInt(INITIAL_PARAM, params, -1));
        this.databaseStructure.prepare(this.optimizer);
    }

    protected String determineSequenceName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String sequenceName = PropertiesHelper.getString(SEQUENCE_PARAM, params, DEF_SEQUENCE_NAME);
        if (sequenceName.indexOf(46) < 0) {
            sequenceName = normalizer.normalizeIdentifierQuoting(sequenceName);
            String schemaName = params.getProperty("schema");
            String catalogName = params.getProperty("catalog");
            sequenceName = Table.qualify(dialect.quote(catalogName), dialect.quote(schemaName), dialect.quote(sequenceName));
        }
        return sequenceName;
    }

    protected String determineValueColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = PropertiesHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected int determineInitialValue(Properties params) {
        return PropertiesHelper.getInt(INITIAL_PARAM, params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return PropertiesHelper.getInt(INCREMENT_PARAM, params, 1);
    }

    protected String determineOptimizationStrategy(Properties params, int incrementSize) {
        String defaultPooledOptimizerStrategy = PropertiesHelper.getBoolean("hibernate.id.optimizer.pooled.prefer_lo", params, false) ? "pooled-lo" : "pooled";
        String defaultOptimizerStrategy = incrementSize <= 1 ? "none" : defaultPooledOptimizerStrategy;
        return PropertiesHelper.getString(OPT_PARAM, params, defaultOptimizerStrategy);
    }

    protected int determineAdjustedIncrementSize(String optimizationStrategy, int incrementSize) {
        if ("none".equals(optimizationStrategy) && incrementSize > 1) {
            log.warn("config specified explicit optimizer of [none], but [increment_size=" + incrementSize + "; honoring optimizer setting");
            incrementSize = 1;
        }
        return incrementSize;
    }

    protected DatabaseStructure buildDatabaseStructure(Type type, Properties params, Dialect dialect, boolean forceTableUse, String sequenceName, int initialValue, int incrementSize) {
        boolean useSequence;
        boolean bl = useSequence = dialect.supportsSequences() && !forceTableUse;
        if (useSequence) {
            return new SequenceStructure(dialect, sequenceName, initialValue, incrementSize, type.getReturnedClass());
        }
        String valueColumnName = this.determineValueColumnName(params, dialect);
        return new TableStructure(dialect, sequenceName, valueColumnName, initialValue, incrementSize, type.getReturnedClass());
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(session));
    }

    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }
}

