/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.sxc;

import com.envoisolutions.sxc.xpath.XPathBuilder;
import com.envoisolutions.sxc.xpath.XPathEvaluator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.sxc.StopProcessingException;
import org.mule.module.sxc.SxcFilter;
import org.mule.module.sxc.UndefinedMatchException;
import org.mule.module.xml.stax.ReversibleXMLStreamReader;
import org.mule.module.xml.transformer.XmlToXMLStreamReader;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.routing.filters.logic.OrFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;

public class SxcFilteringOutboundRouter
extends FilteringOutboundRouter {
    private static final ThreadLocal<MuleMessage> messages = new ThreadLocal();
    private static final XmlToXMLStreamReader transformer = new XmlToXMLStreamReader();
    private Map<String, String> namespaces;
    private XPathEvaluator evaluator;
    private XPathBuilder builder;
    private NamespaceManager namespaceManager;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
        if (this.namespaceManager != null) {
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, String>(this.namespaceManager.getNamespaces());
            } else {
                this.namespaces.putAll(this.namespaceManager.getNamespaces());
            }
        }
    }

    public void setFilter(Filter filter) {
        super.setFilter(filter);
    }

    protected void addEventHandlers(XPathBuilder xpathBuilder, Filter filter) {
        if (filter instanceof SxcFilter) {
            SxcFilter sxcFilter = (SxcFilter)filter;
            sxcFilter.addEventHandler(this, xpathBuilder);
        } else if (filter instanceof AndFilter) {
            AndFilter f = (AndFilter)filter;
            Iterator itr = f.getFilters().iterator();
            while (itr.hasNext()) {
                this.addEventHandlers(xpathBuilder, (Filter)itr.next());
            }
        } else if (filter instanceof OrFilter) {
            OrFilter f = (OrFilter)filter;
            Iterator itr = f.getFilters().iterator();
            while (itr.hasNext()) {
                this.addEventHandlers(xpathBuilder, (Filter)itr.next());
            }
        } else if (filter instanceof NotFilter) {
            NotFilter f = (NotFilter)filter;
            this.addEventHandlers(xpathBuilder, f.getFilter());
        } else {
            this.logger.warn((Object)("Filter type " + filter.getClass().toString() + " is not recognized by the SXC router. If it contains child " + "SXC filters it will not work correctly."));
        }
    }

    protected void initialize() throws Exception {
        if (this.evaluator == null) {
            this.doInitialize();
        }
    }

    private synchronized void doInitialize() {
        if (this.evaluator == null) {
            this.builder = new XPathBuilder();
            this.builder.setNamespaceContext(this.namespaces);
            this.addEventHandlers(this.builder, this.getFilter());
            this.evaluator = this.builder.compile();
        }
    }

    public boolean isMatch(MuleMessage message) throws MuleException {
        ReversibleXMLStreamReader reader = null;
        try {
            this.initialize();
            messages.set(message);
            reader = this.getXMLStreamReader(message);
            reader.setTracking(true);
            this.evaluator.evaluate((XMLStreamReader)reader);
        }
        catch (StopProcessingException e) {
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        finally {
            messages.set(null);
            if (reader != null) {
                reader.setTracking(false);
                reader.reset();
            }
        }
        try {
            return this.testMatch(message);
        }
        catch (UndefinedMatchException m) {
            return false;
        }
    }

    public boolean testMatch(MuleMessage message) throws MuleException {
        return super.isMatch(message);
    }

    protected ReversibleXMLStreamReader getXMLStreamReader(MuleMessage message) throws TransformerException {
        ReversibleXMLStreamReader r = (ReversibleXMLStreamReader)transformer.transform((Object)message);
        if (r != message.getPayload()) {
            message.setPayload((Object)r);
        }
        return r;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public static MuleMessage getCurrentMessage() {
        return messages.get();
    }

    static {
        transformer.setReversible(true);
    }
}

