/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.sqlstrategy;

import org.mule.transport.jdbc.sqlstrategy.CallableSqlStatementStrategy;
import org.mule.transport.jdbc.sqlstrategy.SelectSqlStatementStrategy;
import org.mule.transport.jdbc.sqlstrategy.SimpleUpdateSqlStatementStrategy;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategy;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategyFactory;

public class DefaultSqlStatementStrategyFactory
implements SqlStatementStrategyFactory {
    protected SimpleUpdateSqlStatementStrategy simpleUpdateSQLStrategy = new SimpleUpdateSqlStatementStrategy();
    protected SelectSqlStatementStrategy selectSQLStrategy = new SelectSqlStatementStrategy();
    protected CallableSqlStatementStrategy callableSQLStrategy = new CallableSqlStatementStrategy();

    @Override
    public SqlStatementStrategy create(String sql, Object payload) throws Exception {
        String sqlLowerCase = sql.toLowerCase();
        if (sqlLowerCase.startsWith("insert") || sqlLowerCase.startsWith("update") || sqlLowerCase.startsWith("delete") || sqlLowerCase.startsWith("merge")) {
            return this.simpleUpdateSQLStrategy;
        }
        if (sqlLowerCase.startsWith("select")) {
            return this.selectSQLStrategy;
        }
        if (sqlLowerCase.startsWith("call")) {
            return this.callableSQLStrategy;
        }
        throw new IllegalArgumentException("No SQL Strategy found for SQL statement: " + sql);
    }
}

