/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression.transformers;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;

public abstract class AbstractExpressionTransformer
extends AbstractMessageTransformer {
    protected List<ExpressionArgument> arguments;

    public AbstractExpressionTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
        this.arguments = new ArrayList<ExpressionArgument>(4);
    }

    public void addArgument(ExpressionArgument argument) {
        this.arguments.add(argument);
    }

    public boolean removeArgument(ExpressionArgument argument) {
        return this.arguments.remove(argument);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.arguments == null || this.arguments.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("arguments[]"), (Initialisable)this);
        }
        for (ExpressionArgument argument : this.arguments) {
            argument.setMuleContext(this.muleContext);
            argument.setExpressionEvaluationClassLoader(Thread.currentThread().getContextClassLoader());
            try {
                argument.validate();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public List<ExpressionArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ExpressionArgument> arguments) {
        this.arguments = arguments;
    }
}

