/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MuleContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractTransaction;

public class DelegateTransaction
extends AbstractTransaction {
    private Transaction delegate = new NullTransaction();

    public DelegateTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    protected void doBegin() throws TransactionException {
    }

    @Override
    protected void doCommit() throws TransactionException {
        this.delegate.commit();
    }

    @Override
    protected void doRollback() throws TransactionException {
        this.delegate.rollback();
    }

    @Override
    public int getStatus() throws TransactionException {
        return this.delegate.getStatus();
    }

    @Override
    public boolean isBegun() throws TransactionException {
        return this.delegate.isBegun();
    }

    @Override
    public boolean isRolledBack() throws TransactionException {
        return this.delegate.isRolledBack();
    }

    @Override
    public boolean isCommitted() throws TransactionException {
        return this.delegate.isCommitted();
    }

    @Override
    public Object getResource(Object key) {
        return this.delegate.getResource(key);
    }

    @Override
    public boolean hasResource(Object key) {
        return this.delegate.hasResource(key);
    }

    @Override
    public boolean supports(Object key, Object resource) {
        return this.delegate.supports(key, resource);
    }

    @Override
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(this.delegate instanceof NullTransaction)) {
            throw new TransactionException(CoreMessages.createStaticMessage("Single resource transaction has already a resource bound"));
        }
        TransactionFactory transactionFactory = this.muleContext.getTransactionFactoryManager().getTransactionFactoryFor(key.getClass());
        this.unbindTransaction();
        this.delegate = transactionFactory.beginTransaction(this.muleContext);
        this.delegate.bindResource(key, resource);
    }

    @Override
    public void setRollbackOnly() throws TransactionException {
        this.delegate.setRollbackOnly();
    }

    @Override
    public boolean isRollbackOnly() throws TransactionException {
        return this.delegate.isRollbackOnly();
    }

    @Override
    public boolean isXA() {
        return this.delegate.isXA();
    }

    @Override
    public void resume() throws TransactionException {
        this.delegate.resume();
    }

    @Override
    public javax.transaction.Transaction suspend() throws TransactionException {
        return this.delegate.suspend();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    public boolean supportsInnerTransaction(Transaction transaction) {
        return this.delegate instanceof NullTransaction || this.delegate == transaction;
    }

    private class NullTransaction
    implements Transaction {
        private NullTransaction() {
        }

        @Override
        public void begin() throws TransactionException {
        }

        @Override
        public void commit() throws TransactionException {
        }

        @Override
        public void rollback() throws TransactionException {
        }

        @Override
        public int getStatus() throws TransactionException {
            return 5;
        }

        @Override
        public boolean isBegun() throws TransactionException {
            return false;
        }

        @Override
        public boolean isRolledBack() throws TransactionException {
            return false;
        }

        @Override
        public boolean isCommitted() throws TransactionException {
            return false;
        }

        @Override
        public Object getResource(Object key) {
            return null;
        }

        @Override
        public boolean hasResource(Object key) {
            return false;
        }

        @Override
        public boolean supports(Object key, Object resource) {
            return true;
        }

        @Override
        public void bindResource(Object key, Object resource) throws TransactionException {
        }

        @Override
        public void setRollbackOnly() throws TransactionException {
        }

        @Override
        public boolean isRollbackOnly() throws TransactionException {
            return false;
        }

        @Override
        public boolean isXA() {
            return false;
        }

        @Override
        public void resume() throws TransactionException {
        }

        @Override
        public javax.transaction.Transaction suspend() throws TransactionException {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }
    }
}

