/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractSplitter;

public class MessageChunkSplitter
extends AbstractSplitter {
    protected int messageSize = 0;

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    @Override
    protected boolean isSplitRequired(MuleEvent event) {
        return this.messageSize != 0;
    }

    @Override
    protected List<MuleMessage> splitMessage(MuleEvent event) throws RoutingException {
        byte[] data;
        MuleMessage message = event.getMessage();
        ArrayList<MuleMessage> messageParts = new ArrayList<MuleMessage>();
        try {
            data = message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new RoutingException(CoreMessages.failedToReadPayload(), event, this.next, e);
        }
        int parts = data.length / this.messageSize;
        if (parts * this.messageSize < data.length) {
            ++parts;
        }
        int len = this.messageSize;
        int pos = 0;
        for (int count = 0; count < parts; ++count) {
            if (pos + len > data.length) {
                len = data.length - pos;
            }
            byte[] buffer = new byte[len];
            System.arraycopy(data, pos, buffer, 0, buffer.length);
            pos += len;
            DefaultMuleMessage part = new DefaultMuleMessage((Object)buffer, message, this.muleContext);
            part.setCorrelationId(message.getUniqueId());
            part.setCorrelationGroupSize(parts);
            part.setCorrelationSequence(count);
            messageParts.add(part);
        }
        return messageParts;
    }
}

