/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.JdkVersionUtils;

public class JdkVersionUtilsTestCase
extends AbstractMuleTestCase {
    private String originalJavaVersion;

    @Before
    public void before() {
        this.originalJavaVersion = System.getProperty("java.version");
    }

    @After
    public void after() {
        JdkVersionUtilsTestCase.setJdkVersion(this.originalJavaVersion);
    }

    private static void setJdkVersion(String version) {
        System.setProperty("java.version", version);
    }

    @Test
    public void testIsSupportedJdkVersion() {
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.6");
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.7");
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.8");
        Assert.assertFalse((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.4.2");
        Assert.assertFalse((boolean)JdkVersionUtils.isSupportedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.4.2_12");
        Assert.assertFalse((boolean)JdkVersionUtils.isSupportedJdkVersion());
    }

    @Test
    public void testSupportedJdkVendor() {
        Assert.assertTrue((boolean)JdkVersionUtils.isSupportedJdkVendor());
    }

    @Test
    public void testRecommendedJdkVersion() {
        JdkVersionUtilsTestCase.setJdkVersion("1.6");
        Assert.assertTrue((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.7");
        Assert.assertTrue((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.8");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.4.2");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
        JdkVersionUtilsTestCase.setJdkVersion("1.6.0_5");
        Assert.assertFalse((boolean)JdkVersionUtils.isRecommendedJdkVersion());
    }

    @Test
    public void testJdkVersion() {
        JdkVersionUtils.JdkVersion jdkVersion = new JdkVersionUtils.JdkVersion("1.7");
        Assert.assertEquals((Object)new Integer(1), (Object)jdkVersion.getMajor());
        Assert.assertEquals((Object)new Integer(7), (Object)jdkVersion.getMinor());
        Assert.assertNull((Object)jdkVersion.getMicro());
        Assert.assertNull((Object)jdkVersion.getUpdate());
        Assert.assertNull((Object)jdkVersion.getMilestone());
        jdkVersion = new JdkVersionUtils.JdkVersion("1.7.0-ea");
        Assert.assertEquals((Object)new Integer(1), (Object)jdkVersion.getMajor());
        Assert.assertEquals((Object)new Integer(7), (Object)jdkVersion.getMinor());
        Assert.assertEquals((Object)new Integer(0), (Object)jdkVersion.getMicro());
        Assert.assertNull((Object)jdkVersion.getUpdate());
        Assert.assertEquals((Object)"ea", (Object)jdkVersion.getMilestone());
        jdkVersion = new JdkVersionUtils.JdkVersion("1.6.0_29-b05");
        Assert.assertEquals((Object)new Integer(1), (Object)jdkVersion.getMajor());
        Assert.assertEquals((Object)new Integer(6), (Object)jdkVersion.getMinor());
        Assert.assertEquals((Object)new Integer(0), (Object)jdkVersion.getMicro());
        Assert.assertEquals((Object)new Integer(29), (Object)jdkVersion.getUpdate());
        Assert.assertEquals((Object)"b05", (Object)jdkVersion.getMilestone());
    }

    @Test
    public void testJdkVersionComparison() {
        JdkVersionUtils.JdkVersion jdk1_3 = new JdkVersionUtils.JdkVersion("1.3");
        JdkVersionUtils.JdkVersion jdk1_6_0_5 = new JdkVersionUtils.JdkVersion("1.6.0_5");
        JdkVersionUtils.JdkVersion jdk1_7 = new JdkVersionUtils.JdkVersion("1.7");
        JdkVersionUtils.JdkVersion jdk1_6_0_29_b04 = new JdkVersionUtils.JdkVersion("1.6.0_29-b04");
        JdkVersionUtils.JdkVersion jdk1_6_0_29_b05 = new JdkVersionUtils.JdkVersion("1.6.0_29-b05");
        Assert.assertTrue((jdk1_3.compareTo(jdk1_7) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_7.compareTo(jdk1_3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_3.compareTo(jdk1_3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b05.compareTo(jdk1_6_0_29_b05) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_5.compareTo(jdk1_6_0_29_b04) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_6_0_5) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_6_0_29_b05) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b05.compareTo(jdk1_6_0_29_b04) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_6_0_29_b04.compareTo(jdk1_7) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((jdk1_7.compareTo(jdk1_6_0_29_b04) > 0 ? 1 : 0) != 0);
    }
}

