/*
 * Decompiled with CFR 0.152.
 */
package org.drools.logger;

import org.drools.ProviderInitializationException;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerProvider;

public class KnowledgeRuntimeLoggerFactory {
    private static KnowledgeRuntimeLoggerProvider knowledgeRuntimeLoggerProvider;

    public static KnowledgeRuntimeLogger newFileLogger(KnowledgeRuntimeEventManager session, String fileName) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newFileLogger(session, fileName);
    }

    public static KnowledgeRuntimeLogger newThreadedFileLogger(KnowledgeRuntimeEventManager session, String fileName, int interval) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newThreadedFileLogger(session, fileName, interval);
    }

    public static KnowledgeRuntimeLogger newConsoleLogger(KnowledgeRuntimeEventManager session) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newConsoleLogger(session);
    }

    private static synchronized void setKnowledgeRuntimeLoggerProvider(KnowledgeRuntimeLoggerProvider provider) {
        knowledgeRuntimeLoggerProvider = provider;
    }

    private static synchronized KnowledgeRuntimeLoggerProvider getKnowledgeRuntimeLoggerProvider() {
        if (knowledgeRuntimeLoggerProvider == null) {
            KnowledgeRuntimeLoggerFactory.loadProvider();
        }
        return knowledgeRuntimeLoggerProvider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.audit.KnowledgeRuntimeLoggerProviderImpl");
            KnowledgeRuntimeLoggerFactory.setKnowledgeRuntimeLoggerProvider((KnowledgeRuntimeLoggerProvider)cls.newInstance());
        }
        catch (Exception e) {
            throw new ProviderInitializationException("Provider org.drools.audit.KnowledgeRuntimeLoggerProviderImpl could not be set.", e);
        }
    }
}

